/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.api.vehicle.IVehicleAccess;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.gameplay.client.RenderHelpers;

public abstract class WirelessModemPeripheralBase
extends WirelessModemPeripheral {
    private World world;
    private Vec3d position;

    public WirelessModemPeripheralBase(boolean advanced) {
        super(new ModemState(), advanced);
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Nonnull
    public Vec3d getPosition() {
        return this.position;
    }

    public void update(@Nonnull World world, @Nonnull Vec3d position) {
        this.position = position;
        if (this.world != world) {
            this.world = world;
            this.switchNetwork();
        }
    }

    public static final class VehicleUpgradeHandler
    extends WirelessModemPeripheralBase
    implements IVehicleUpgradeHandler {
        @SideOnly(value=Side.CLIENT)
        private ModelResourceLocation offModel;
        @SideOnly(value=Side.CLIENT)
        private ModelResourceLocation onModel;
        private final ItemStack stack;

        VehicleUpgradeHandler(boolean advanced, ItemStack stack) {
            super(advanced);
            this.stack = stack;
        }

        public boolean equals(IPeripheral other) {
            return this == other || other instanceof VehicleUpgradeHandler && this.stack == ((VehicleUpgradeHandler)other).stack;
        }

        @Override
        public void update(@Nonnull IVehicleAccess vehicle, @Nonnull IPeripheral peripheral) {
            ModemPeripheral modem;
            Entity entity = vehicle.getVehicle();
            this.update(entity.func_130014_f_(), entity.func_174791_d());
            if (peripheral instanceof ModemPeripheral && (modem = (ModemPeripheral)peripheral).getModemState().pollChanged()) {
                vehicle.getData().func_74757_a("active", modem.getModemState().isOpen());
                vehicle.markDataDirty();
            }
        }

        @Override
        public IPeripheral create(@Nonnull IVehicleAccess vehicle) {
            return this;
        }

        @Override
        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public Pair<IBakedModel, Matrix4f> getModel(@Nonnull IVehicleAccess access) {
            this.loadModelLocations();
            boolean active = access.getData().func_74767_n("active");
            ModelManager modelManager = RenderHelpers.getMesher().func_178083_a();
            return Pair.of((Object)modelManager.func_174953_a(active ? this.onModel : this.offModel), (Object)RenderHelpers.getIdentity());
        }

        @SideOnly(value=Side.CLIENT)
        private void loadModelLocations() {
            if (this.offModel != null) {
                return;
            }
            if (this.isInterdimensional()) {
                this.offModel = new ModelResourceLocation("computercraft:advanced_modem_off", "inventory");
                this.onModel = new ModelResourceLocation("computercraft:advanced_modem_on", "inventory");
            } else {
                this.offModel = new ModelResourceLocation("computercraft:wireless_modem_off", "inventory");
                this.onModel = new ModelResourceLocation("computercraft:wireless_modem_on", "inventory");
            }
        }
    }

    public static final class PeripheralHandler
    extends WirelessModemPeripheralBase
    implements IPeripheralHandler {
        private final ItemStack stack;

        PeripheralHandler(boolean advanced, ItemStack stack) {
            super(advanced);
            this.stack = stack;
        }

        public boolean equals(IPeripheral other) {
            return this == other || other instanceof PeripheralHandler && this.stack == ((PeripheralHandler)other).stack;
        }

        @Override
        @Nonnull
        public IPeripheral getPeripheral() {
            return this;
        }

        @Override
        public void update(@Nonnull World world, @Nonnull Vec3d position, @Nullable EntityLivingBase entity) {
            this.update(world, position);
        }
    }
}

