/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.squiddev.plethora.gameplay.ItemBase;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.client.ModelInterface;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.gameplay.neural.NeuralComputer;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.gameplay.neural.NeuralItemHandler;
import org.squiddev.plethora.gameplay.neural.NeuralRegistry;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.LoadedCache;
import org.squiddev.plethora.utils.PlayerHelpers;
import org.squiddev.plethora.utils.TinySlot;
import vazkii.botania.api.item.ICosmeticAttachable;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="vazkii.botania.api.item.ICosmeticAttachable", modid="botania")})
@Mod.EventBusSubscriber(modid="plethora")
public class ItemNeuralInterface
extends ItemArmor
implements ISpecialArmor,
IComputerItem,
IMedia,
IBauble,
ICosmeticAttachable {
    private static final ItemArmor.ArmorMaterial FAKE_ARMOUR = EnumHelper.addArmorMaterial((String)"FAKE_ARMOUR", (String)"iwasbored_fake", (int)-1, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187713_n, (float)2.0f);
    private static final ISpecialArmor.ArmorProperties FAKE_PROPERTIES = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    private static final String NAME = "neuralInterface";

    public ItemNeuralInterface() {
        super(FAKE_ARMOUR, 0, NeuralHelpers.ARMOR_SLOT);
        this.setRegistryName(new ResourceLocation("plethora", NAME));
        this.func_77655_b("plethora.neuralInterface");
        this.func_77637_a(Plethora.getCreativeTab());
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (!NeuralRegistry.instance.canEquip(entity)) {
            return false;
        }
        if (entity.func_184582_a(NeuralHelpers.ARMOR_SLOT).func_190926_b() && stack.func_190916_E() == 1) {
            if (!player.func_130014_f_().field_72995_K) {
                entity.func_184201_a(NeuralHelpers.ARMOR_SLOT, stack.func_77946_l());
                if (entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving)entity;
                    living.func_184642_a(NeuralHelpers.ARMOR_SLOT, 2.0f);
                    living.func_110163_bv();
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190920_e(0);
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult hit = PlayerHelpers.findHitGuess(player);
        Entity entity = hit.field_72308_g;
        if (hit.field_72313_a == RayTraceResult.Type.ENTITY && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184582_a(NeuralHelpers.ARMOR_SLOT).func_190926_b() && stack.func_190916_E() == 1) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (LoadedCache.hasBaubles()) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int slot : NeuralHelpers.getBaubleType().getValidSlots()) {
                if (!handler.getStackInSlot(slot).func_190926_b()) continue;
                if (!world.field_72995_K) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190917_f(-1);
                    }
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private static void onUpdate(ItemStack stack, TinySlot inventory, EntityLivingBase player, boolean forceActive) {
        if (player.func_130014_f_().field_72995_K) {
            if (forceActive && player instanceof EntityPlayer) {
                ItemComputerHandler.getClient(stack);
            }
        } else {
            short dirtyStatus;
            String label;
            NeuralComputer neural;
            NBTTagCompound tag = ItemBase.getTag(stack);
            if (forceActive) {
                neural = ItemComputerHandler.getServer(stack, player, inventory);
                neural.keepAlive();
            } else {
                neural = ItemComputerHandler.tryGetServer(stack);
                if (neural == null) {
                    return;
                }
            }
            boolean dirty = false;
            int newId = neural.getID();
            if (!tag.func_74764_b("id") || tag.func_74762_e("id") != newId) {
                tag.func_74768_a("id", newId);
                dirty = true;
            }
            String newLabel = neural.getLabel();
            String string = label = stack.func_82837_s() ? stack.func_82833_r() : null;
            if (!Objects.equal((Object)newLabel, (Object)label)) {
                if (newLabel == null || newLabel.isEmpty()) {
                    stack.func_135074_t();
                } else {
                    stack.func_151001_c(newLabel);
                }
                dirty = true;
            }
            if ((dirtyStatus = tag.func_74765_d("dirty")) != 0) {
                tag.func_74777_a("dirty", (short)0);
                dirty = true;
            }
            if (neural.update(player, stack, dirtyStatus)) {
                dirty = true;
            }
            if (dirty && inventory != null) {
                inventory.markDirty();
            }
        }
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        return new InvProvider(stack);
    }

    public boolean setLabel(@Nonnull ItemStack stack, String name) {
        if (name == null) {
            stack.func_135074_t();
        } else {
            stack.func_151001_c(name);
        }
        return true;
    }

    public String getAudioTitle(@Nonnull ItemStack stack) {
        return null;
    }

    public SoundEvent getAudio(@Nonnull ItemStack stack) {
        return null;
    }

    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int id = this.getComputerID(stack);
        return id >= 0 ? ComputerCraftAPI.createSaveDirMount((World)world, (String)("computer/" + id), (long)ComputerCraft.computerSpaceLimit) : null;
    }

    public int getComputerID(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("id") ? tag.func_74762_e("id") : -1;
    }

    public String getLabel(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return stack.func_82837_s() ? stack.func_82833_r() : null;
    }

    public ComputerFamily getFamily(@Nonnull ItemStack stack) {
        return ComputerFamily.Advanced;
    }

    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return stack;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return NeuralHelpers.getBaubleType();
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player));
        for (int slot : NeuralHelpers.getBaubleType().getValidSlots()) {
            ItemStack slotStack = handler.getStackInSlot(slot);
            if (slotStack != stack) continue;
            ItemNeuralInterface.onUpdate(stack, new TinySlot.BaublesSlot(stack, handler, slot), player, true);
        }
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    @Nonnull
    public ItemStack getCosmeticItem(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("cosmetic", 10) ? new ItemStack(tag.func_74775_l("cosmetic")) : ItemStack.field_190927_a;
    }

    public void setCosmeticItem(@Nonnull ItemStack stack, @Nonnull ItemStack cosmetic) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        if (cosmetic.func_190926_b()) {
            tag.func_82580_o("cosmetic");
        } else {
            tag.func_74782_a("cosmetic", (NBTBase)cosmetic.serializeNBT());
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entityLivingBase, @Nonnull ItemStack itemStack, DamageSource damageSource, double v, int i) {
        return FAKE_PROPERTIES;
    }

    public int getArmorDisplay(EntityPlayer entityPlayer, @Nonnull ItemStack itemStack, int i) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entityLivingBase, @Nonnull ItemStack itemStack, DamageSource damageSource, int damage, int slot) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> out, ITooltipFlag flag) {
        ItemStack cosmetic;
        super.func_77624_a(stack, world, out, flag);
        out.add(Helpers.translateToLocal(this.func_77667_c(stack) + ".desc"));
        NBTTagCompound tag = stack.func_77978_p();
        if (flag.func_194127_a() && tag != null && tag.func_74764_b("id")) {
            out.add("Computer ID " + tag.func_74762_e("id"));
        }
        if (LoadedCache.hasBotania() && !(cosmetic = this.getCosmeticItem(stack)).func_190926_b()) {
            out.add(Helpers.translateToLocalFormatted("botaniamisc.hasCosmetic", cosmetic.func_82833_r()).replaceAll("&", "\u00a7"));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        ItemNeuralInterface.onUpdate(stack, new TinySlot.InventorySlot(stack, (IInventory)player.field_71071_by), (EntityLivingBase)player, true);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int um1, boolean um2) {
        super.func_77663_a(stack, world, entity, um1, um2);
        if (entity instanceof EntityLivingBase) {
            TinySlot slot = entity instanceof EntityPlayer ? new TinySlot.InventorySlot(stack, (IInventory)((EntityPlayer)entity).field_71071_by) : new TinySlot(stack);
            ItemNeuralInterface.onUpdate(stack, slot, (EntityLivingBase)entity, false);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped existing) {
        return ModelInterface.getNormal();
    }

    @Nonnull
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String existing) {
        return "plethora:textures/models/neural_interface.png";
    }

    @SubscribeEvent
    public static void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        TinySlot slot = NeuralHelpers.getSlot(event.getEntityLiving());
        if (slot != null) {
            ItemNeuralInterface.onUpdate(slot.getStack(), slot, event.getEntityLiving(), true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && Helpers.onEntityInteract((Item)Registration.itemNeuralInterface, event.getEntityPlayer(), event.getTarget(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    private static final class InvProvider
    implements ICapabilityProvider {
        private final IItemHandler inv;

        private InvProvider(ItemStack stack) {
            this.inv = new NeuralItemHandler(stack);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.inv;
            }
            return null;
        }
    }
}

