/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasHandler;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectRegistry;
import org.squiddev.plethora.gameplay.registry.BasicMessage;

public class MessageCanvasAdd
implements BasicMessage {
    private int canvasId;
    private BaseObject[] objects;

    public MessageCanvasAdd(int canvasId, BaseObject[] objects) {
        this.canvasId = canvasId;
        this.objects = objects;
    }

    public MessageCanvasAdd() {
    }

    public void fromBytes(ByteBuf buf) {
        this.canvasId = buf.readInt();
        int size = buf.readInt();
        this.objects = new BaseObject[size];
        BaseObject[] objects = this.objects;
        for (int i = 0; i < size; ++i) {
            objects[i] = ObjectRegistry.read(buf);
        }
        Arrays.sort(objects, BaseObject.SORTING_ORDER);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.canvasId);
        buf.writeInt(this.objects.length);
        for (BaseObject object : this.objects) {
            ObjectRegistry.write(buf, object);
        }
    }

    @Override
    public void onMessage(MessageContext context) {
        CanvasClient canvas = new CanvasClient(this.canvasId);
        for (BaseObject obj : this.objects) {
            canvas.updateObject(obj);
        }
        CanvasHandler.addClient(canvas);
    }
}

