/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;

public class CanvasClient {
    public final int id;
    private final Int2ObjectMap<BaseObject> objects = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IntSortedSet> childrenOf = new Int2ObjectOpenHashMap();

    public CanvasClient(int id) {
        this.id = id;
        this.childrenOf.put(0, (Object)new IntAVLTreeSet());
        this.childrenOf.put(1, (Object)new IntAVLTreeSet());
    }

    public void updateObject(BaseObject object) {
        IntSet parent = (IntSet)this.childrenOf.get(object.parent());
        if (parent == null) {
            Plethora.LOG.error("Trying to add " + object.id() + " to group " + object.parent() + " (" + object + ")");
            return;
        }
        if (this.objects.put(object.id(), (Object)object) == null) {
            parent.add(object.id());
            if (object instanceof ObjectGroup) {
                this.childrenOf.put(object.id(), (Object)new IntAVLTreeSet());
            }
        }
    }

    public void remove(int id) {
        IntSet parent;
        BaseObject object = (BaseObject)this.objects.remove(id);
        this.childrenOf.remove(id);
        if (object != null && (parent = (IntSet)this.childrenOf.get(object.parent())) != null) {
            parent.remove(id);
        }
    }

    public BaseObject getObject(int id) {
        return (BaseObject)this.objects.get(id);
    }

    public IntSet getChildren(int id) {
        return (IntSet)this.childrenOf.get(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawChildren(IntIterator children) {
        while (children.hasNext()) {
            int id = children.nextInt();
            BaseObject object = this.getObject(id);
            if (object == null) continue;
            object.draw(this);
        }
    }
}

