/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.core.TurtleUpgradeModule;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.integration.PlayerInteractionHelpers;
import org.squiddev.plethora.integration.computercraft.FakePlayerProviderTurtle;
import org.squiddev.plethora.utils.PlayerHelpers;

public class TurtleUpgradeKinetic
extends TurtleUpgradeModule {
    public TurtleUpgradeKinetic(@Nonnull ItemStack stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        super(stack, handler, adjective);
    }

    @Override
    @Nonnull
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Both;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        if (this.isBlacklisted()) {
            return TurtleCommandResult.failure();
        }
        TurtleUpgradeModule.TurtlePlayerOwnable ownable = new TurtleUpgradeModule.TurtlePlayerOwnable(turtle);
        PlethoraFakePlayer fakePlayer = FakePlayerProviderTurtle.getPlayer(turtle, ownable);
        FakePlayerProviderTurtle.load(fakePlayer, turtle, direction);
        try {
            RayTraceResult hit = PlayerHelpers.findHit((EntityLivingBase)fakePlayer, 1.5);
            if (verb == TurtleVerb.Dig && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                Pair<Boolean, String> previous = null;
                for (int i = 0; i < 4; ++i) {
                    Pair<Boolean, String> result = fakePlayer.dig(hit.func_178782_a(), hit.field_178784_b);
                    if (!((Boolean)result.getLeft()).booleanValue()) {
                        TurtleCommandResult turtleCommandResult = previous != null ? TurtleUpgradeKinetic.toResult(previous) : TurtleUpgradeKinetic.toResult(result);
                        return turtleCommandResult;
                    }
                    previous = result;
                }
                TurtleCommandResult turtleCommandResult = TurtleUpgradeKinetic.toResult(previous);
                return turtleCommandResult;
            }
            if (verb == TurtleVerb.Attack && hit.field_72313_a == RayTraceResult.Type.ENTITY) {
                TurtleCommandResult turtleCommandResult = TurtleUpgradeKinetic.toResult(PlayerInteractionHelpers.attack((EntityPlayerMP)fakePlayer, hit.field_72308_g));
                return turtleCommandResult;
            }
            TurtleCommandResult turtleCommandResult = TurtleCommandResult.failure((String)"Nothing to do here");
            return turtleCommandResult;
        }
        finally {
            fakePlayer.func_184602_cy();
            FakePlayerProviderTurtle.unload(fakePlayer, turtle);
            fakePlayer.updateCooldown();
        }
    }

    private static TurtleCommandResult toResult(Pair<Boolean, String> result) {
        return (Boolean)result.getLeft() != false ? TurtleCommandResult.success((Object[])new Object[]{result.getRight()}) : TurtleCommandResult.failure((String)((String)result.getRight()));
    }
}

