/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import org.squiddev.plethora.utils.MatrixHelpers;

public enum ManipulatorType implements IStringSerializable
{
    MARK_1(0.5f, new AxisAlignedBB(0.3125, 0.625, 0.3125, 0.6875, 0.6875, 0.6875)),
    MARK_2(0.25f, new AxisAlignedBB(0.1875, 0.625, 0.1875, 0.3125, 0.6875, 0.3125), new AxisAlignedBB(0.1875, 0.625, 0.6875, 0.3125, 0.6875, 0.8125), new AxisAlignedBB(0.6875, 0.625, 0.1875, 0.8125, 0.6875, 0.3125), new AxisAlignedBB(0.6875, 0.625, 0.6875, 0.8125, 0.6875, 0.8125), new AxisAlignedBB(0.4375, 0.625, 0.4375, 0.5625, 0.6875, 0.5625));

    public static final ManipulatorType[] VALUES;
    private final String name = this.name().toLowerCase();
    private final AxisAlignedBB[] boxes;
    private final AxisAlignedBB[][] facingBoxes;
    public final float scale;

    private ManipulatorType(float scale, AxisAlignedBB ... boxes) {
        this.scale = scale;
        this.boxes = boxes;
        this.facingBoxes = new AxisAlignedBB[6][];
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int size() {
        return this.boxes.length;
    }

    public AxisAlignedBB[] boxesFor(EnumFacing facing) {
        AxisAlignedBB[] cached = this.facingBoxes[facing.ordinal()];
        if (cached != null) {
            return cached;
        }
        Matrix4f m = MatrixHelpers.matrixFor(facing);
        cached = new AxisAlignedBB[this.boxes.length];
        for (int i = 0; i < this.boxes.length; ++i) {
            cached[i] = MatrixHelpers.transform(this.boxes[i], m);
        }
        this.facingBoxes[facing.ordinal()] = cached;
        return cached;
    }

    static {
        VALUES = ManipulatorType.values();
    }
}

