/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.minecart;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.Plethora;

public class CommandAPI
extends CommandBlockBaseLogic
implements ILuaAPI {
    private final Entity entity;
    private final MinecraftServer server;
    private final Map<Integer, String> output = new HashMap<Integer, String>();

    public CommandAPI(Entity entity) {
        this.entity = entity;
        this.server = entity.func_130014_f_().func_73046_m();
    }

    public String[] getNames() {
        return new String[]{"commands"};
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"exec", "execAsync", "list", "getBlockPosition", "getBlockInfos", "getBlockInfo"};
    }

    private static Map<Object, Object> createOutput(String output) {
        return Collections.singletonMap(1, output);
    }

    private Object[] doCommand(String command) {
        if (this.server == null || !this.server.func_82356_Z()) {
            return new Object[]{false, Collections.singletonMap(1, "Command blocks disabled by server")};
        }
        ICommandManager commandManager = this.server.func_71187_D();
        try {
            this.output.clear();
            int result = commandManager.func_71556_a((ICommandSender)this, command);
            return new Object[]{result > 0, new HashMap<Integer, String>(this.output)};
        }
        catch (Exception | LinkageError t) {
            return new Object[]{false, Collections.singletonMap(1, "Java Exception Thrown: " + t)};
        }
    }

    private static Object getBlockInfo(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        HashMap<String, Object> table = new HashMap<String, Object>(3);
        table.put("name", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
        table.put("metadata", block.func_176201_c(state));
        HashMap<String, Object> stateTable = new HashMap<String, Object>();
        for (Map.Entry entry : state.func_185899_b((IBlockAccess)world, pos).func_177228_b().entrySet()) {
            IProperty property = (IProperty)entry.getKey();
            stateTable.put(property.func_177701_a(), CommandAPI.getPropertyValue(property, (Comparable)entry.getValue()));
        }
        table.put("state", stateTable);
        return table;
    }

    private static Object getPropertyValue(IProperty property, Comparable value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        return property.func_177702_a(value);
    }

    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                String command = ArgumentHelper.getString((Object[])arguments, (int)0);
                return context.executeMainThreadTask(() -> this.doCommand(command));
            }
            case 1: {
                String command = ArgumentHelper.getString((Object[])arguments, (int)0);
                long taskID = context.issueMainThreadTask(() -> this.doCommand(command));
                return new Object[]{taskID};
            }
            case 2: {
                return context.executeMainThreadTask(() -> {
                    int i = 1;
                    HashMap<Integer, String> result = new HashMap<Integer, String>();
                    if (this.server != null) {
                        ICommandManager commandManager = this.server.func_71187_D();
                        Map commands = commandManager.func_71555_a();
                        for (Map.Entry entry : commands.entrySet()) {
                            String name = (String)entry.getKey();
                            ICommand command = (ICommand)entry.getValue();
                            try {
                                if (!command.func_184882_a(this.server, (ICommandSender)this.entity)) continue;
                                result.put(i++, name);
                            }
                            catch (Throwable t) {
                                Plethora.LOG.error("Error checking permissions of command.", t);
                            }
                        }
                    }
                    return new Object[]{result};
                });
            }
            case 3: {
                BlockPos pos = this.entity.func_180425_c();
                return new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            }
            case 4: {
                int minX = ArgumentHelper.getInt((Object[])arguments, (int)0);
                int minY = ArgumentHelper.getInt((Object[])arguments, (int)1);
                int minZ = ArgumentHelper.getInt((Object[])arguments, (int)2);
                int maxX = ArgumentHelper.getInt((Object[])arguments, (int)3);
                int maxY = ArgumentHelper.getInt((Object[])arguments, (int)4);
                int maxZ = ArgumentHelper.getInt((Object[])arguments, (int)5);
                return context.executeMainThreadTask(() -> {
                    World world = this.func_130014_f_();
                    BlockPos min = new BlockPos(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
                    BlockPos max = new BlockPos(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
                    if (!world.func_175701_a(min) || !world.func_175701_a(max)) {
                        throw new LuaException("Co-ordinates out or range");
                    }
                    if ((max.func_177958_n() - min.func_177958_n() + 1) * (max.func_177956_o() - min.func_177956_o() + 1) * (max.func_177952_p() - min.func_177952_p() + 1) > 4096) {
                        throw new LuaException("Too many blocks");
                    }
                    int i = 1;
                    HashMap<Integer, Object> results = new HashMap<Integer, Object>();
                    for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                        for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                results.put(i++, CommandAPI.getBlockInfo(world, pos));
                            }
                        }
                    }
                    return new Object[]{results};
                });
            }
            case 5: {
                int x = ArgumentHelper.getInt((Object[])arguments, (int)0);
                int y = ArgumentHelper.getInt((Object[])arguments, (int)1);
                int z = ArgumentHelper.getInt((Object[])arguments, (int)2);
                return context.executeMainThreadTask(() -> {
                    BlockPos position;
                    World world = this.func_130014_f_();
                    if (!world.func_175701_a(position = new BlockPos(x, y, z))) {
                        throw new LuaException("co-ordinates out or range");
                    }
                    return new Object[]{CommandAPI.getBlockInfo(world, position)};
                });
            }
        }
        return null;
    }

    @Nonnull
    public String func_70005_c_() {
        return this.entity.func_70005_c_();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.entity.func_145748_c_();
    }

    public void func_145747_a(@Nonnull ITextComponent component) {
        this.output.put(this.output.size() + 1, component.func_150260_c());
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return permLevel <= 2;
    }

    @Nonnull
    public BlockPos func_180425_c() {
        return this.entity.func_180425_c();
    }

    @Nonnull
    public Vec3d func_174791_d() {
        return this.entity.func_174791_d();
    }

    @Nonnull
    public World func_130014_f_() {
        return this.entity.func_130014_f_();
    }

    public Entity func_174793_f() {
        return this.entity;
    }

    public void func_174794_a(@Nonnull CommandResultStats.Type type, int amount) {
    }

    public void func_145756_e() {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_145751_f() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145757_a(@Nonnull ByteBuf byteBuf) {
    }

    @Nullable
    public MinecraftServer func_184102_h() {
        return this.server;
    }
}

