/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.core.MethodWrapperPeripheral;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.executor.TaskRunner;

public class AttachableWrapperPeripheral
extends MethodWrapperPeripheral {
    private final Collection<IAttachable> attachments;
    private final AtomicInteger count = new AtomicInteger(0);

    public AttachableWrapperPeripheral(String name, Object owner, Pair<List<IMethod<?>>, List<UnbakedContext<?>>> methods, TaskRunner runner, Collection<IAttachable> attachments) {
        super(name, owner, methods, runner);
        this.attachments = attachments;
    }

    @Override
    public void attach(@Nonnull IComputerAccess access) {
        super.attach(access);
        int count = this.count.getAndIncrement();
        if (count == 0) {
            for (IAttachable attachable : this.attachments) {
                attachable.attach();
            }
        }
    }

    @Override
    public void detach(@Nonnull IComputerAccess access) {
        super.detach(access);
        int count = this.count.decrementAndGet();
        if (count == 0) {
            for (IAttachable attachable : this.attachments) {
                attachable.detach();
            }
        }
    }
}

