/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.proxy;

import java.util.Map;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.item.ItemEssenceBerry;
import josephcsible.oreberries.item.ItemNugget;
import josephcsible.oreberries.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    protected static final ModelResourceLocation nuggetMRL = new ModelResourceLocation(new ResourceLocation("oreberries", "nugget"), "inventory");
    protected static final ModelResourceLocation oreberryMRL = new ModelResourceLocation(new ResourceLocation("oreberries", "oreberry"), "inventory");
    protected static final ModelResourceLocation oreberryBushMRL = new ModelResourceLocation(new ResourceLocation("oreberries", "oreberry_bush"), "inventory");
    protected static final ModelResourceLocation essenceBerryMRL = new ModelResourceLocation(new ResourceLocation("oreberries", "essence_berry"), "inventory");
    protected static final ModelResourceLocation essenceBerryBushMRL = new ModelResourceLocation(new ResourceLocation("oreberries", "essence_berry_bush"), "inventory");

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (ItemNugget item : nuggets) {
            int color = Integer.decode(item.config.color);
            itemColors.func_186730_a((stack, tintIndex) -> color, new Item[]{item});
        }
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (BlockOreberryBush block : oreberryBushBlocks) {
            int color = Integer.decode(block.config.color);
            blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> color, new Block[]{block});
            itemColors.func_186730_a((stack, tintIndex) -> color, new Item[]{Item.func_150898_a((Block)block), block.berries});
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (ItemNugget item : nuggets) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)nuggetMRL);
        }
        for (BlockOreberryBush block : oreberryBushBlocks) {
            if (ItemEssenceBerry.isEssence(block.config.special)) {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)OreberryBushBlockStateMapper.ESSENCE_BERRY);
                ModelLoader.setCustomModelResourceLocation((Item)block.berries, (int)0, (ModelResourceLocation)essenceBerryMRL);
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)essenceBerryBushMRL);
                continue;
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)OreberryBushBlockStateMapper.OREBERRY);
            ModelLoader.setCustomModelResourceLocation((Item)block.berries, (int)0, (ModelResourceLocation)oreberryMRL);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)oreberryBushMRL);
        }
    }

    @Override
    public boolean isOreberryBushOpaqueCube(IBlockState state) {
        return !Minecraft.func_71410_x().field_71474_y.field_74347_j && (Integer)state.func_177229_b((IProperty)BlockOreberryBush.AGE) >= 2;
    }

    protected static class OreberryBushBlockStateMapper
    extends StateMapperBase {
        public static final OreberryBushBlockStateMapper OREBERRY = new OreberryBushBlockStateMapper("oreberries", "oreberry_bush");
        public static final OreberryBushBlockStateMapper ESSENCE_BERRY = new OreberryBushBlockStateMapper("oreberries", "essence_berry_bush");
        protected final ResourceLocation rl;

        protected OreberryBushBlockStateMapper(String resourceDomainIn, String resourcePathIn) {
            this.rl = new ResourceLocation(resourceDomainIn, resourcePathIn);
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation(this.rl, this.func_178131_a((Map)state.func_177228_b()));
        }
    }
}

