/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.layout.IExpander;

public class Column
extends ParentWidget<Column>
implements ILayoutWidget,
IExpander {
    private Alignment.MainAxis maa = Alignment.MainAxis.START;
    private Alignment.CrossAxis caa = Alignment.CrossAxis.CENTER;

    public Column() {
        ((Flex)this.flex().startDefaultMode().sizeRel(1.0f, 1.0f)).endDefaultMode();
    }

    @Override
    public void layoutWidgets() {
        boolean hasHeight = this.resizer().isHeightCalculated();
        int height = this.getArea().height;
        Box padding = this.getArea().getPadding();
        Alignment.MainAxis maa = this.maa;
        if (!hasHeight && maa != Alignment.MainAxis.START) {
            if (this.flex().yAxisDependsOnChildren()) {
                maa = Alignment.MainAxis.START;
            } else {
                throw new IllegalStateException("Alignment.MainAxis other than start need the height to be calculated!");
            }
        }
        int totalHeight = 0;
        int expandedAmount = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasYPos()) continue;
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                totalHeight += widget.getArea().getMargin().vertical();
                continue;
            }
            totalHeight += widget.getArea().requestedHeight();
        }
        if (expandedAmount > 0 && hasHeight) {
            int newHeight = (height - totalHeight - padding.vertical()) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (widget.flex().hasYPos() || !widget.flex().isExpanded()) continue;
                widget.getArea().height = newHeight;
                widget.resizer().setHeightResized(true);
            }
            if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
                maa = Alignment.MainAxis.START;
            }
        }
        int lastY = padding.top;
        if (hasHeight) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastY = (int)((float)height / 2.0f - (float)totalHeight / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastY = height - totalHeight;
            }
        }
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasYPos()) continue;
            Box margin = widget.getArea().getMargin();
            widget.getArea().ry = lastY + margin.top;
            widget.resizer().setYResized(true);
            widget.resizer().setYMarginPaddingApplied(true);
            lastY += widget.getArea().requestedHeight();
            if (!hasHeight || maa != Alignment.MainAxis.SPACE_BETWEEN) continue;
            lastY += (height - totalHeight) / (this.getChildren().size() - 1);
        }
    }

    @Override
    public void postLayoutWidgets() {
        int width = this.getArea().width;
        Box padding = this.getArea().getPadding();
        boolean hasWidth = this.resizer().isWidthCalculated();
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasYPos()) continue;
            Box margin = widget.getArea().getMargin();
            if (widget.flex().hasXPos() || !widget.resizer().isWidthCalculated()) continue;
            int x = margin.left + padding.left;
            if (hasWidth) {
                if (this.caa == Alignment.CrossAxis.CENTER) {
                    x = (int)((float)width / 2.0f - (float)widget.getArea().width / 2.0f);
                } else if (this.caa == Alignment.CrossAxis.END) {
                    x = width - widget.getArea().width - margin.right - padding.left;
                }
            }
            widget.getArea().rx = x;
            widget.resizer().setXResized(true);
            widget.resizer().setXMarginPaddingApplied(true);
        }
    }

    public Column crossAxisAlignment(Alignment.CrossAxis caa) {
        this.caa = caa;
        return this;
    }

    public Column mainAxisAlignment(Alignment.MainAxis maa) {
        this.maa = maa;
        return this;
    }

    @Override
    public GuiAxis getExpandAxis() {
        return GuiAxis.Y;
    }
}

