/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IValueWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.widget.DraggableWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ListWidget;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortableListWidget<T, I extends Item<T>>
extends ListWidget<T, I, SortableListWidget<T, I>> {
    private Consumer<List<T>> onChange;
    private Consumer<Item<T>> onRemove;
    private int timeSinceLastMove = 0;

    public static <T, I extends Item<T>> SortableListWidget<T, I> sortableBuilder(Collection<T> fullList, List<T> list, Function<T, I> builder) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(builder);
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        SortableListWidget<Object, Item> sortableListWidget = new SortableListWidget<Object, Item>(((Map)map)::get);
        for (T t : fullList) {
            Item item = (Item)builder.apply(t);
            map.put(t, item);
        }
        for (T t : list) {
            if (!fullList.contains(t)) {
                throw new IllegalArgumentException("Elements from list must also be inside the full list!");
            }
            sortableListWidget.add(t, -1);
        }
        return sortableListWidget;
    }

    public SortableListWidget(Function<T, I> valueToWidgetMapper) {
        super(valueToWidgetMapper, Item::getWidgetValue);
        ((Flex)this.flex().startDefaultMode().width(80)).endDefaultMode();
    }

    @Override
    public void onInit() {
        this.assignIndexes();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ++this.timeSinceLastMove;
    }

    @Override
    public boolean addChild(IWidget child, int index) {
        Object value = this.widgetToValueMapper.apply((Item)child);
        if (child != this.valueToWidgetMapper.apply(value)) {
            throw new IllegalArgumentException();
        }
        ((Item)child).listWidget = this;
        if (super.addChild(child, index)) {
            if (this.isValid()) {
                this.assignIndexes();
                if (this.onChange != null) {
                    this.onChange.accept(this.getValues());
                }
            }
            return true;
        }
        return false;
    }

    public void moveTo(int from, int to) {
        if (this.timeSinceLastMove < 3) {
            return;
        }
        if (from < 0 || to < 0 || from == to) {
            ModularUI.LOGGER.error("Failed to move element from {} to {}", (Object)from, (Object)to);
            return;
        }
        Item child = (Item)this.getChildren().remove(from);
        this.getChildren().add(to, child);
        this.assignIndexes();
        if (this.isValid()) {
            WidgetTree.resize(this);
        }
        if (this.onChange != null) {
            this.onChange.accept(this.getValues());
        }
        this.timeSinceLastMove = 0;
    }

    @Override
    public boolean remove(int index) {
        IWidget widget = this.getChildren().remove(index);
        if (widget != null) {
            this.assignIndexes();
            if (this.isValid()) {
                WidgetTree.resize(this);
            }
            if (this.onChange != null) {
                this.onChange.accept(this.getValues());
            }
            if (this.onRemove != null) {
                this.onRemove.accept((Item)widget);
            }
            return true;
        }
        return false;
    }

    private void assignIndexes() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Item item = (Item)this.getChildren().get(i);
            item.index = i;
        }
    }

    public SortableListWidget<T, I> onChange(Consumer<List<T>> onChange) {
        this.onChange = onChange;
        return this;
    }

    public SortableListWidget<T, I> onRemove(Consumer<Item<T>> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    public static class Item<T>
    extends DraggableWidget<Item<T>>
    implements IValueWidget<T> {
        private final T value;
        private final IWidget content;
        private ButtonWidget<? extends ButtonWidget<?>> removeButton;
        private final List<IWidget> children = new ArrayList<IWidget>();
        private Predicate<IGuiElement> dropPredicate;
        private SortableListWidget<T, ? extends Item<T>> listWidget;
        private int index = -1;

        public Item(T value, IWidget content) {
            this.value = value;
            this.content = content;
            this.children.add(content);
            this.content.flex().heightRel(1.0f);
            ((Flex)this.flex().widthRel(1.0f)).height(18);
            this.background(GuiTextures.BUTTON_CLEAN);
        }

        @Override
        public void onInit() {
            super.onInit();
            if (this.removeButton != null) {
                this.children.add(this.removeButton);
            }
        }

        @Override
        @NotNull
        public List<IWidget> getChildren() {
            return this.children;
        }

        @Override
        public boolean canDropHere(int x, int y, @Nullable IGuiElement widget) {
            return this.dropPredicate == null || this.dropPredicate.test(widget);
        }

        @Override
        public void onDrag(int mouseButton, long timeSinceLastClick) {
            super.onDrag(mouseButton, timeSinceLastClick);
            IGuiElement hovered = this.getContext().getHovered();
            Item item = (Item)WidgetTree.findParent(hovered, guiElement -> guiElement instanceof Item);
            if (item != null && item != this && item.listWidget == this.listWidget) {
                this.listWidget.moveTo(this.index, item.index);
            }
        }

        @Override
        public void onDragEnd(boolean successful) {
        }

        @Override
        public T getWidgetValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }

        public Item<T> dropPredicate(Predicate<IGuiElement> dropPredicate) {
            this.dropPredicate = dropPredicate;
            return this;
        }

        public Item<T> removeable() {
            this.removeButton = (ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((Widget)new ButtonWidget().onMousePressed(mouseButton -> this.listWidget.remove(this.index))).background(GuiTextures.CLOSE.asIcon())).width(10)).heightRel(1.0f)).right(0);
            return this;
        }

        public Item<T> removeable(Consumer<ButtonWidget<? extends ButtonWidget<?>>> buttonBuilder) {
            this.removeable();
            buttonBuilder.accept(this.removeButton);
            return this;
        }
    }
}

