/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ItemSlotSH
extends SyncHandler {
    private final ModularSlot slot;
    private ItemStack lastStoredItem;
    private ItemStack lastStoredPhantomItem = ItemStack.field_190927_a;

    @ApiStatus.Internal
    public ItemSlotSH(ModularSlot slot) {
        this.slot = slot;
    }

    @Override
    public void init(String key, GuiSyncManager syncHandler) {
        super.init(key, syncHandler);
        syncHandler.getContainer().registerSlot(this.slot);
        this.lastStoredItem = this.getSlot().func_75211_c().func_77946_l();
        if (this.isPhantom() && !this.getSlot().func_75211_c().func_190926_b()) {
            this.lastStoredPhantomItem = this.getSlot().func_75211_c().func_77946_l();
            this.lastStoredPhantomItem.func_190920_e(1);
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        ItemStack itemStack = this.getSlot().func_75211_c();
        if (itemStack.func_190926_b() && this.lastStoredItem.func_190926_b()) {
            return;
        }
        boolean onlyAmountChanged = false;
        if (init || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastStoredItem, (ItemStack)itemStack) || (onlyAmountChanged = itemStack.func_190916_E() != this.lastStoredItem.func_190916_E())) {
            this.getSlot().onSlotChangedReal(itemStack, onlyAmountChanged, false, init);
            if (onlyAmountChanged) {
                this.lastStoredItem.func_190920_e(itemStack.func_190916_E());
            } else {
                this.lastStoredItem = itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l();
            }
            boolean finalOnlyAmountChanged = onlyAmountChanged;
            this.syncToClient(1, buffer -> {
                buffer.writeBoolean(finalOnlyAmountChanged);
                buffer.func_150788_a(itemStack);
                buffer.writeBoolean(init);
            });
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 1) {
            boolean onlyAmountChanged = buf.readBoolean();
            this.lastStoredItem = NetworkUtils.readItemStack(buf);
            this.getSlot().onSlotChangedReal(this.lastStoredItem, onlyAmountChanged, true, buf.readBoolean());
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 2) {
            this.phantomClick(MouseData.readPacket(buf));
        } else if (id == 3) {
            this.phantomScroll(MouseData.readPacket(buf));
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        } else if (id == 5) {
            if (!this.isPhantom()) {
                return;
            }
            ItemStack stack = buf.func_150791_c();
            this.slot.func_75215_d(stack);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(MouseData mouseData) {
        ItemStack cursorStack = this.getSyncManager().getCursorItem();
        ItemStack slotStack = this.getSlot().func_75211_c();
        if (!(cursorStack.func_190926_b() || slotStack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)cursorStack, (ItemStack)slotStack))) {
            ItemStack stackToPut = cursorStack.func_77946_l();
            if (mouseData.mouseButton == 1) {
                stackToPut.func_190920_e(1);
            }
            this.getSlot().func_75215_d(stackToPut);
            this.lastStoredPhantomItem = stackToPut.func_77946_l();
            return;
        } else if (slotStack.func_190926_b()) {
            ItemStack stackToPut;
            if (cursorStack.func_190926_b()) {
                if (mouseData.mouseButton != 1 || this.lastStoredPhantomItem.func_190926_b()) return;
                stackToPut = this.lastStoredPhantomItem.func_77946_l();
            } else {
                stackToPut = cursorStack.func_77946_l();
            }
            if (mouseData.mouseButton == 1) {
                stackToPut.func_190920_e(1);
            }
            this.getSlot().func_75215_d(stackToPut);
            this.lastStoredPhantomItem = stackToPut.func_77946_l();
            return;
        } else if (mouseData.mouseButton == 0) {
            if (mouseData.shift) {
                this.slot.func_75215_d(ItemStack.field_190927_a);
                return;
            } else {
                this.incrementStackCount(-1);
            }
            return;
        } else {
            if (mouseData.mouseButton != 1) return;
            this.incrementStackCount(1);
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        ItemStack currentItem = this.slot.func_75211_c();
        int amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 4;
        }
        if (mouseData.ctrl) {
            amount *= 16;
        }
        if (mouseData.alt) {
            amount *= 64;
        }
        if (amount > 0 && currentItem.func_190926_b() && !this.lastStoredPhantomItem.func_190926_b()) {
            ItemStack stackToPut = this.lastStoredPhantomItem.func_77946_l();
            stackToPut.func_190920_e(amount);
            this.slot.func_75215_d(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.getSlot().func_75211_c();
        if (stack.func_190926_b()) {
            return;
        }
        int oldAmount = stack.func_190916_E();
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getSlot().func_75219_a();
            if (!this.slot.isIgnoreMaxStackSize() && stack.func_77976_d() < maxSize) {
                maxSize = stack.func_77976_d();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack = stack.func_77946_l();
            stack.func_190920_e(amount);
            this.getSlot().func_75215_d(stack);
        }
    }

    public void setEnabled(boolean enabled, boolean sync) {
        this.slot.setEnabled(enabled);
        if (sync) {
            this.sync(4, buffer -> buffer.writeBoolean(enabled));
        }
    }

    public void updateFromClient(ItemStack stack) {
        this.syncToServer(5, buf -> buf.func_150788_a(stack));
    }

    public ModularSlot getSlot() {
        return this.slot;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.getSlot().func_75214_a(itemStack);
    }

    public boolean isPhantom() {
        return this.slot.isPhantom();
    }

    @Nullable
    public String getSlotGroup() {
        return this.slot.getSlotGroupName();
    }
}

