/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.value.IEnumValue;
import com.cleanroommc.modularui.api.value.sync.IIntSyncValue;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class EnumSyncValue<T extends Enum<T>>
extends ValueSyncHandler<T>
implements IEnumValue<T>,
IIntSyncValue<T> {
    private final Class<T> enumCLass;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private T cache;

    public EnumSyncValue(Class<T> enumCLass, Supplier<T> getter, Consumer<T> setter) {
        this.enumCLass = enumCLass;
        this.getter = getter;
        this.setter = setter;
        this.cache = (Enum)getter.get();
    }

    @Contract(value="_, null, _, null, _ -> fail")
    public EnumSyncValue(Class<T> enumCLass, @Nullable Supplier<T> clientGetter, @Nullable Consumer<T> clientSetter, @Nullable Supplier<T> serverGetter, @Nullable Consumer<T> serverSetter) {
        this.enumCLass = enumCLass;
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (NetworkUtils.isClient()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = (Enum)this.getter.get();
    }

    @Override
    public Class<T> getEnumClass() {
        return this.enumCLass;
    }

    @Override
    public T getValue() {
        return this.cache;
    }

    @Override
    public void setValue(T value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        if (sync) {
            this.sync(0, this::write);
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.getter.get() != this.cache) {
            this.setValue((T)((Enum)this.getter.get()), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getValue());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue((T)buffer.func_179257_a(this.enumCLass), true, false);
    }

    @Override
    public void setIntValue(int value, boolean setSource, boolean sync) {
        this.setValue((T)((Enum[])this.enumCLass.getEnumConstants())[value], setSource, sync);
    }

    @Override
    public int getIntValue() {
        return ((Enum)this.cache).ordinal();
    }
}

