/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.PanelManager;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.Dialog;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class ModularScreen {
    private final String owner;
    private final String name;
    private final PanelManager panelManager;
    private final GuiContext context = new GuiContext(this);
    private final Area screenArea = new Area();
    private final Map<Class<?>, List<IGuiAction>> guiActionListeners = new Object2ObjectOpenHashMap();
    private final Object2ObjectArrayMap<IWidget, Runnable> frameUpdates = new Object2ObjectArrayMap();
    private ITheme currentTheme;
    private GuiScreenWrapper screenWrapper;

    public static boolean isScreen(@Nullable GuiScreen guiScreen, String owner, String name) {
        if (guiScreen instanceof GuiScreenWrapper) {
            GuiScreenWrapper screenWrapper = (GuiScreenWrapper)guiScreen;
            ModularScreen screen = screenWrapper.getScreen();
            return screen.getOwner().equals(owner) && screen.getName().equals(name);
        }
        return false;
    }

    public static boolean isActive(String owner, String name) {
        return ModularScreen.isScreen(Minecraft.func_71410_x().field_71462_r, owner, name);
    }

    @Nullable
    public static ModularScreen getCurrent() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiScreenWrapper) {
            GuiScreenWrapper screenWrapper = (GuiScreenWrapper)guiScreen;
            return screenWrapper.getScreen();
        }
        return null;
    }

    public ModularScreen(@NotNull ModularPanel mainPanel) {
        this("modularui", mainPanel);
    }

    public ModularScreen(@NotNull String owner, @NotNull ModularPanel mainPanel) {
        this(owner, (GuiContext context) -> mainPanel);
    }

    public ModularScreen(@NotNull String owner, @NotNull Function<GuiContext, ModularPanel> mainPanelCreator) {
        this(owner, Objects.requireNonNull(mainPanelCreator, "The main panel function must not be null!"), false);
    }

    private ModularScreen(@NotNull String owner, @Nullable Function<GuiContext, ModularPanel> mainPanelCreator, boolean ignored) {
        Objects.requireNonNull(owner, "The owner must not be null!");
        this.owner = owner;
        ModularPanel mainPanel = mainPanelCreator != null ? mainPanelCreator.apply(this.context) : this.buildUI(this.context);
        Objects.requireNonNull(mainPanel, "The main panel must not be null!");
        this.name = mainPanel.getName();
        this.currentTheme = IThemeApi.get().getThemeForScreen(this, null);
        this.panelManager = new PanelManager(this, mainPanel);
    }

    ModularScreen(@NotNull String owner) {
        this(owner, null, false);
    }

    ModularPanel buildUI(GuiContext context) {
        throw new UnsupportedOperationException();
    }

    @MustBeInvokedByOverriders
    void construct(GuiScreenWrapper wrapper) {
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (wrapper == null) {
            throw new NullPointerException("GuiScreenWrapper must not be null!");
        }
        this.screenWrapper = wrapper;
        this.screenWrapper.updateArea(this.panelManager.getMainPanel().getArea());
    }

    public void onResize(int width, int height) {
        this.screenArea.set(0, 0, width, height);
        this.screenArea.z(0);
        this.context.pushViewport(null, this.screenArea);
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            WidgetTree.resize(panel);
        }
        this.context.popViewport(null);
        this.screenWrapper.updateArea(this.panelManager.getMainPanel().getArea());
    }

    public void onOpen() {
        this.panelManager.init();
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        this.panelManager.closeAll();
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean force) {
        if (this.isActive()) {
            if (force) {
                this.context.mc.field_71439_g.func_71053_j();
                return;
            }
            this.getMainPanel().closeIfOpen(true);
        }
    }

    public void openPanel(ModularPanel panel) {
        this.panelManager.openPanel(panel);
    }

    public void closePanel(ModularPanel panel) {
        this.panelManager.closePanel(panel);
    }

    public boolean isPanelOpen(String name) {
        return this.panelManager.isPanelOpen(name);
    }

    public boolean isPanelOpen(ModularPanel panel) {
        return this.panelManager.hasOpenPanel(panel);
    }

    @MustBeInvokedByOverriders
    public void onUpdate() {
        this.context.tick();
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            WidgetTree.onUpdate(panel);
        }
    }

    @MustBeInvokedByOverriders
    public void onFrameUpdate() {
        this.panelManager.checkDirty();
        ObjectIterator iterator = this.frameUpdates.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            if (!((IWidget)entry.getKey()).isValid()) {
                iterator.remove();
                continue;
            }
            ((Runnable)entry.getValue()).run();
        }
        this.context.onFrameUpdate();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.context.updateState(mouseX, mouseY, partialTicks);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        this.context.reset();
        this.context.pushViewport(null, this.screenArea);
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            if (panel.disablePanelsBelow()) {
                GuiDraw.drawRect(0.0f, 0.0f, this.screenArea.w(), this.screenArea.h(), Color.argb(16, 16, 16, (int)(125.0f * panel.getAlpha())));
            }
            WidgetTree.drawTree(panel, this.context);
        }
        this.context.popViewport(null);
        this.context.postRenderCallbacks.forEach(element -> element.accept(this.context));
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
    }

    public void drawForeground(float partialTicks) {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        this.context.reset();
        this.context.pushViewport(null, this.screenArea);
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            if (!panel.isEnabled()) continue;
            WidgetTree.drawTreeForeground(panel, this.context);
        }
        this.context.drawDraggable();
        this.context.popViewport(null);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
    }

    public boolean onMousePressed(int mouseButton) {
        this.context.updateEventState();
        for (IGuiAction.MousePressed action : this.getGuiActionListeners(IGuiAction.MousePressed.class)) {
            action.press(mouseButton);
        }
        if (this.context.onMousePressed(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMousePressed(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseRelease(int mouseButton) {
        this.context.updateEventState();
        for (IGuiAction.MouseReleased action : this.getGuiActionListeners(IGuiAction.MouseReleased.class)) {
            action.release(mouseButton);
        }
        if (this.context.onMouseReleased(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseRelease(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        this.context.updateEventState();
        for (IGuiAction.KeyPressed action : this.getGuiActionListeners(IGuiAction.KeyPressed.class)) {
            action.press(typedChar, keyCode);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyPressed(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyRelease(char typedChar, int keyCode) {
        this.context.updateEventState();
        for (IGuiAction.KeyReleased action : this.getGuiActionListeners(IGuiAction.KeyReleased.class)) {
            action.release(typedChar, keyCode);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyRelease(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        this.context.updateEventState();
        for (IGuiAction.MouseScroll action : this.getGuiActionListeners(IGuiAction.MouseScroll.class)) {
            action.scroll(scrollDirection, amount);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseScroll(scrollDirection, amount)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        this.context.updateEventState();
        for (IGuiAction.MouseDrag action : this.getGuiActionListeners(IGuiAction.MouseDrag.class)) {
            action.drag(mouseButton, timeSinceClick);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseDrag(mouseButton, timeSinceClick)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public <T> void openDialog(String name, Consumer<Dialog<T>> dialogBuilder) {
        this.openDialog(name, dialogBuilder, null);
    }

    public <T> void openDialog(String name, Consumer<Dialog<T>> dialogBuilder, Consumer<T> resultConsumer) {
        Dialog<T> dialog = new Dialog<T>(name, resultConsumer);
        ((Flex)dialog.flex().size(150, 100)).align(Alignment.Center);
        dialog.background(GuiTextures.MC_BACKGROUND);
        dialogBuilder.accept(dialog);
        this.openPanel(dialog);
    }

    @ApiStatus.Internal
    public void setFocused(boolean focus) {
        this.screenWrapper.func_193975_a(focus);
    }

    public boolean isActive() {
        return ModularScreen.getCurrent() == this;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.owner, this.name);
    }

    public GuiContext getContext() {
        return this.context;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public PanelManager getWindowManager() {
        return this.panelManager;
    }

    public PanelManager getPanelManager() {
        return this.panelManager;
    }

    public GuiSyncManager getSyncManager() {
        return this.getContainer().getSyncManager();
    }

    public ModularPanel getMainPanel() {
        return this.panelManager.getMainPanel();
    }

    public GuiScreenWrapper getScreenWrapper() {
        return this.screenWrapper;
    }

    public Area getScreenArea() {
        return this.screenArea;
    }

    public boolean isClientOnly() {
        return this.getContainer().isClientOnly();
    }

    public ModularContainer getContainer() {
        return (ModularContainer)this.screenWrapper.field_147002_h;
    }

    private <T extends IGuiAction> List<T> getGuiActionListeners(Class<T> clazz) {
        return this.guiActionListeners.getOrDefault(clazz, Collections.emptyList());
    }

    public void registerGuiActionListener(IGuiAction action) {
        this.guiActionListeners.computeIfAbsent(ModularScreen.getGuiActionClass(action), key -> new ArrayList()).add(action);
    }

    public void removeGuiActionListener(IGuiAction action) {
        this.guiActionListeners.getOrDefault(ModularScreen.getGuiActionClass(action), Collections.emptyList()).remove(action);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable) {
        this.registerFrameUpdateListener(widget, runnable, true);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable, boolean merge) {
        Objects.requireNonNull(runnable);
        if (merge) {
            this.frameUpdates.merge((Object)widget, (Object)runnable, (old, now) -> () -> {
                old.run();
                now.run();
            });
        } else {
            this.frameUpdates.put((Object)widget, (Object)runnable);
        }
    }

    public void removeFrameUpdateListener(IWidget widget) {
        this.frameUpdates.remove((Object)widget);
    }

    private static Class<?> getGuiActionClass(IGuiAction action) {
        Class<?>[] classes;
        for (Class<?> clazz : classes = action.getClass().getInterfaces()) {
            if (!IGuiAction.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new IllegalArgumentException();
    }

    public ITheme getCurrentTheme() {
        return this.currentTheme;
    }

    public ModularScreen useTheme(String theme) {
        this.currentTheme = IThemeApi.get().getThemeForScreen(this, theme);
        return this;
    }

    public static enum UpOrDown {
        UP(1),
        DOWN(-1);

        public final int modifier;

        private UpOrDown(int modifier) {
            this.modifier = modifier;
        }

        public boolean isUp() {
            return this == UP;
        }

        public boolean isDown() {
            return this == DOWN;
        }
    }
}

