/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.keybind;

import com.cleanroommc.modularui.core.mixin.KeyBindAccess;
import com.cleanroommc.modularui.keybind.KeyBindAPI;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyBindHandler {
    private static void checkKeyState(int key, boolean state) {
        if (key != 0) {
            KeyBinding keyBinding;
            for (KeyBinding keyBinding2 : KeyBindHandler.getKeyBindingMap().lookupAll(key)) {
                if (!KeyBindAPI.doForceCheckKeyBind(keyBinding2)) continue;
                ((KeyBindAccess)keyBinding2).setPressed(state);
            }
            if (state && (keyBinding = KeyBindHandler.getKeyBindingMap().lookupActive(key)) != null) {
                Collection<KeyBinding> compatibles;
                if (KeyBindAPI.doForceCheckKeyBind(keyBinding)) {
                    KeyBindHandler.incrementPressTime(keyBinding);
                }
                if ((compatibles = KeyBindAPI.getCompatibles(keyBinding)).isEmpty()) {
                    return;
                }
                for (KeyBinding keyBinding1 : compatibles) {
                    if (!keyBinding1.isActiveAndMatches(key) || !KeyBindAPI.doForceCheckKeyBind(keyBinding1)) continue;
                    KeyBindHandler.incrementPressTime(keyBinding1);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGuiKeyInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!event.getGui().func_193976_p()) {
            int key = Keyboard.getEventKey();
            boolean state = Keyboard.getEventKeyState();
            KeyBindHandler.checkKeyState(key, state);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!event.getGui().func_193976_p()) {
            int key = Mouse.getEventButton() - 100;
            boolean state = Mouse.getEventButtonState();
            KeyBindHandler.checkKeyState(key, state);
        }
    }

    public static KeyBindingMap getKeyBindingMap() {
        return ((KeyBindAccess)Minecraft.func_71410_x().field_71474_y.field_74322_I).getHASH();
    }

    public static void incrementPressTime(KeyBinding keyBinding) {
        ((KeyBindAccess)keyBinding).setPressTime(((KeyBindAccess)keyBinding).getPressTime() + 1);
    }
}

