/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.integration.jei;

import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import java.awt.Rectangle;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;

@Optional.Interface(iface="mezz.jei.api.gui.IGhostIngredientHandler$Target", modid="jei")
public class GhostIngredientTarget<I>
implements IGhostIngredientHandler.Target<I> {
    private final IGuiElement guiElement;
    private final JeiGhostIngredientSlot<I> ghostSlot;

    public static <I> GhostIngredientTarget<I> of(JeiGhostIngredientSlot<I> slot) {
        if (slot instanceof IGuiElement) {
            IGuiElement guiElement = (IGuiElement)((Object)slot);
            return new GhostIngredientTarget<I>(guiElement, slot);
        }
        throw new IllegalArgumentException();
    }

    public static <I, W extends IWidget & JeiGhostIngredientSlot<I>> GhostIngredientTarget<I> of(W slot) {
        return new GhostIngredientTarget<I>(slot, slot);
    }

    public GhostIngredientTarget(IGuiElement guiElement, JeiGhostIngredientSlot<I> ghostSlot) {
        this.guiElement = guiElement;
        this.ghostSlot = ghostSlot;
    }

    @NotNull
    public Rectangle getArea() {
        return this.guiElement.getArea();
    }

    public void accept(@NotNull I ingredient) {
        if ((ingredient = this.ghostSlot.castGhostIngredientIfValid(ingredient)) == null) {
            throw new IllegalStateException("Ghost slot did accept ingredient before, but now it doesn't.");
        }
        this.ghostSlot.setGhostIngredient(ingredient);
    }
}

