/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PosGuiData;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class TileEntityGuiFactory
extends AbstractUIFactory<PosGuiData> {
    public static final TileEntityGuiFactory INSTANCE = new TileEntityGuiFactory();

    private TileEntityGuiFactory() {
        super("mui:tile");
    }

    public static <T extends TileEntity> void open(EntityPlayer player, T tile) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(tile);
        if (tile.func_145837_r()) {
            throw new IllegalArgumentException("Can't open invalid TileEntity GUI!");
        }
        if (player.field_70170_p != tile.func_145831_w()) {
            throw new IllegalArgumentException("TileEntity must be in same dimension as the player!");
        }
        BlockPos pos = tile.func_174877_v();
        PosGuiData data = new PosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        GuiManager.open(INSTANCE, data, (EntityPlayerMP)player);
    }

    public static void open(EntityPlayer player, BlockPos pos) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(pos);
        PosGuiData data = new PosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        GuiManager.open(INSTANCE, data, (EntityPlayerMP)player);
    }

    @Override
    @NotNull
    public IGuiHolder<PosGuiData> getGuiHolder(PosGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getTileEntity()), "Found TileEntity is not a gui holder!");
    }

    @Override
    public void writeGuiData(PosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
    }

    @Override
    @NotNull
    public PosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }
}

