/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.keys;

import com.cleanroommc.modularui.api.drawable.IKey;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class StringKey
implements IKey {
    private final String string;
    private final Object[] args;

    public StringKey(String string) {
        this(string, null);
    }

    public StringKey(String string, @Nullable Object[] args) {
        this.string = Objects.requireNonNull(string);
        this.args = args == null || args.length == 0 ? null : args;
    }

    @Override
    public String get() {
        return this.args == null ? this.string : String.format(this.string, this.args);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringKey) {
            StringKey stringKey = (StringKey)obj;
            return this.string.equals(stringKey.string);
        }
        return false;
    }

    public String toString() {
        return this.string;
    }
}

