/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.IntConsumer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Rectangle
implements IDrawable {
    public static final double PI_2 = 1.5707963267948966;
    private int cornerRadius;
    private int colorTL;
    private int colorTR;
    private int colorBL;
    private int colorBR;
    private int cornerSegments;
    private boolean canApplyTheme = false;

    public Rectangle() {
        this.setColor(-1);
        this.cornerRadius = 0;
        this.cornerSegments = 6;
    }

    public int getColor() {
        return this.colorTL;
    }

    public Rectangle setCornerRadius(int cornerRadius) {
        this.cornerRadius = Math.max(0, cornerRadius);
        return this;
    }

    public Rectangle setColor(int colorTL, int colorTR, int colorBL, int colorBR) {
        this.colorTL = colorTL;
        this.colorTR = colorTR;
        this.colorBL = colorBL;
        this.colorBR = colorBR;
        return this;
    }

    public Rectangle setVerticalGradient(int colorTop, int colorBottom) {
        return this.setColor(colorTop, colorTop, colorBottom, colorBottom);
    }

    public Rectangle setHorizontalGradient(int colorLeft, int colorRight) {
        return this.setColor(colorLeft, colorRight, colorLeft, colorRight);
    }

    public Rectangle setColor(int color) {
        return this.setColor(color, color, color, color);
    }

    public Rectangle setCornerSegments(int cornerSegments) {
        this.cornerSegments = cornerSegments;
        return this;
    }

    public Rectangle setCanApplyTheme(boolean canApplyTheme) {
        this.canApplyTheme = canApplyTheme;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x0, int y0, int width, int height, WidgetTheme widgetTheme) {
        if (this.canApplyTheme()) {
            Color.setGlColor(widgetTheme.getColor());
        } else {
            Color.setGlColorOpaque(Color.WHITE.main);
        }
        if (this.cornerRadius <= 0) {
            GuiDraw.drawRect(x0, y0, width, height, this.colorTL, this.colorTR, this.colorBL, this.colorBR);
            return;
        }
        GuiDraw.drawRoundedRect(x0, y0, width, height, this.colorTL, this.colorTR, this.colorBL, this.colorBR, this.cornerRadius, this.cornerSegments);
    }

    @Override
    public boolean canApplyTheme() {
        return this.canApplyTheme;
    }

    @Override
    public void loadFromJson(JsonObject json) {
        int c;
        if (json.has("color")) {
            this.setColor(Color.ofJson(json.get("color")));
        }
        if (json.has("colorTop")) {
            this.colorTL = c = Color.ofJson(json.get("colorTop"));
            this.colorTR = c;
        }
        if (json.has("colorBottom")) {
            this.colorBL = c = Color.ofJson(json.get("colorBottom"));
            this.colorBR = c;
        }
        if (json.has("colorLeft")) {
            this.colorTL = c = Color.ofJson(json.get("colorLeft"));
            this.colorBL = c;
        }
        if (json.has("colorRight")) {
            this.colorTR = c = Color.ofJson(json.get("colorRight"));
            this.colorBR = c;
        }
        this.setColor(json, val -> {
            this.colorTL = val;
        }, "colorTopLeft", "colorTL");
        this.setColor(json, val -> {
            this.colorTR = val;
        }, "colorTopRight", "colorTR");
        this.setColor(json, val -> {
            this.colorBL = val;
        }, "colorBottomLeft", "colorBL");
        this.setColor(json, val -> {
            this.colorBR = val;
        }, "colorBottomRight", "colorBR");
        this.cornerRadius = JsonHelper.getInt(json, 0, "cornerRadius");
        this.cornerSegments = JsonHelper.getInt(json, 10, "cornerSegments");
    }

    private void setColor(JsonObject json, IntConsumer color, String ... keys) {
        JsonElement element = JsonHelper.getJsonElement(json, keys);
        if (element != null) {
            color.accept(Color.ofJson(element));
        }
    }
}

