/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.GameObjectHelper;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemDrawable
implements IDrawable {
    private ItemStack item = ItemStack.field_190927_a;

    public ItemDrawable() {
    }

    public ItemDrawable(@NotNull ItemStack item) {
        this.item = item;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        GuiDraw.drawItem(this.item, x, y, width, height);
    }

    @Override
    public Icon asIcon() {
        return IDrawable.super.asIcon().size(16);
    }

    public ItemDrawable setItem(@NotNull ItemStack item) {
        this.item = item;
        return this;
    }

    public static ItemDrawable ofJson(JsonObject json) {
        ItemStack item;
        String itemS = JsonHelper.getString(json, null, "item");
        if (itemS == null) {
            throw new JsonParseException("Item property not found!");
        }
        String[] parts = itemS.split(":");
        if (parts.length < 2) {
            throw new JsonParseException("Item property must have be in the format 'mod:item_name:meta'");
        }
        int meta = 0;
        if (parts.length > 2) {
            try {
                meta = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        try {
            item = GameObjectHelper.getItemStack(parts[0], parts[1], meta);
        }
        catch (NoSuchElementException e) {
            throw new JsonParseException((Throwable)e);
        }
        if (json.has("nbt")) {
            try {
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)JsonHelper.getObject(json, new JsonObject(), o -> o, "nbt").toString());
                item.func_77982_d(nbt);
            }
            catch (NBTException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        return new ItemDrawable(item);
    }
}

