/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.AnimatedText;
import com.cleanroommc.modularui.drawable.StyledText;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.drawable.keys.CompoundKey;
import com.cleanroommc.modularui.drawable.keys.DynamicKey;
import com.cleanroommc.modularui.drawable.keys.LangKey;
import com.cleanroommc.modularui.drawable.keys.StringKey;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public interface IKey
extends IDrawable {
    public static final int TEXT_COLOR = -12566464;
    public static final TextRenderer renderer = new TextRenderer();
    public static final IKey EMPTY = new StringKey("");

    public static IKey lang(@NotNull String key) {
        return new LangKey(key);
    }

    public static IKey lang(@NotNull String key, Object ... args) {
        return new LangKey(key, args);
    }

    public static IKey str(@NotNull String key) {
        return new StringKey(key);
    }

    public static IKey format(@NotNull String key, Object ... args) {
        return new StringKey(key, args);
    }

    public static IKey comp(IKey ... keys) {
        return new CompoundKey(keys);
    }

    public static IKey dynamic(@NotNull Supplier<String> getter) {
        return new DynamicKey(getter);
    }

    public String get();

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        renderer.setColor(widgetTheme.getTextColor());
        renderer.setShadow(widgetTheme.getTextShadow());
        renderer.setAlignment(Alignment.Center, width, height);
        renderer.setScale(1.0f);
        renderer.setPos(x, y);
        renderer.draw(this.get());
    }

    default public TextWidget asWidget() {
        return new TextWidget(this);
    }

    default public StyledText withStyle() {
        return new StyledText(this);
    }

    default public AnimatedText withAnimation() {
        return new AnimatedText(this);
    }

    default public StyledText alignment(Alignment alignment) {
        return this.withStyle().alignment(alignment);
    }

    default public StyledText color(int color) {
        return this.withStyle().color(color);
    }

    default public StyledText scale(float scale) {
        return this.withStyle().scale(scale);
    }

    default public StyledText shadow(boolean shadow) {
        return this.withStyle().shadow(shadow);
    }

    @Override
    default public void loadFromJson(JsonObject json) {
        if (json.has("color") || json.has("shadow") || json.has("align") || json.has("alignment") || json.has("scale")) {
            StyledText styledText1;
            StyledText styledText;
            IKey iKey = this;
            StyledText styledText2 = styledText = iKey instanceof StyledText ? (styledText1 = (StyledText)iKey) : this.withStyle();
            if (json.has("color")) {
                styledText.color(JsonHelper.getInt(json, 0, "color"));
            }
            styledText.shadow(JsonHelper.getBoolean(json, false, "shadow"));
            styledText.alignment(JsonHelper.deserialize(json, Alignment.class, styledText.getAlignment(), "align", "alignment"));
            styledText.scale(JsonHelper.getFloat(json, 1.0f, "scale"));
        }
    }
}

