/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.CastingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Casting")
@ZenRegister
@ModOnly(value="tconstruct")
public class Casting {
    public static final Map<IItemStack, ILiquidStack> REMOVED_RECIPES_TABLE = new LinkedHashMap<IItemStack, ILiquidStack>();
    public static final Map<IItemStack, ILiquidStack> REMOVED_RECIPES_BASIN = new LinkedHashMap<IItemStack, ILiquidStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Casting());
            init = true;
        }
    }

    @ZenMethod
    public static void addTableRecipe(IItemStack output, IIngredient cast, ILiquidStack fluid, int amount, @Optional boolean consumeCast, @Optional int time) {
        Casting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), cast, InputHelper.toFluid((ILiquidStack)fluid), amount, true, consumeCast, time));
    }

    @ZenMethod
    public static void addBasinRecipe(IItemStack output, IIngredient cast, ILiquidStack fluid, int amount, @Optional boolean consumeCast, @Optional int time) {
        Casting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), cast, InputHelper.toFluid((ILiquidStack)fluid), amount, false, consumeCast, time));
    }

    @ZenMethod
    public static void removeTableRecipe(IItemStack output, @Optional ILiquidStack input) {
        Casting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input, true));
    }

    @ZenMethod
    public static void removeBasinRecipe(IItemStack output, @Optional ILiquidStack input) {
        Casting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input, false));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.TableCastingRegisterEvent event) {
        if (event.getRecipe() instanceof CastingRecipeTweaker || !(event.getRecipe() instanceof CastingRecipe)) {
            return;
        }
        for (Map.Entry<IItemStack, ILiquidStack> ent : REMOVED_RECIPES_TABLE.entrySet()) {
            IItemStack stack = ent.getKey();
            if (stack == null || ((CastingRecipe)event.getRecipe()).getResult() == null) continue;
            if (ent.getValue() == null) {
                if (!stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult()))) continue;
                event.setCanceled(true);
                continue;
            }
            if (!stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult())) || !((CastingRecipe)event.getRecipe()).getFluid().isFluidEqual((FluidStack)ent.getValue().getInternal())) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.BasinCastingRegisterEvent event) {
        if (event.getRecipe() instanceof CastingRecipeTweaker || !(event.getRecipe() instanceof CastingRecipe)) {
            return;
        }
        for (Map.Entry<IItemStack, ILiquidStack> ent : REMOVED_RECIPES_BASIN.entrySet()) {
            IItemStack stack = ent.getKey();
            if (stack == null || ((CastingRecipe)event.getRecipe()).getResult() == null || !stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult()))) continue;
            if (ent.getValue() != null) {
                if (!((CastingRecipe)event.getRecipe()).getFluid().isFluidEqual((FluidStack)ent.getValue().getInternal())) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack output;
        IIngredient cast;
        private FluidStack fluid;
        private int amount;
        private boolean table;
        private boolean consumeCast;
        private int time;

        public Add(ItemStack output, IIngredient cast, FluidStack fluid, int amount, boolean table, boolean consumeCast, int time) {
            super("Casting");
            this.output = output;
            this.cast = cast;
            this.fluid = fluid;
            this.amount = amount;
            this.table = table;
            this.consumeCast = consumeCast;
            this.time = time != 0 ? time : CastingRecipe.calcCooldownTime((Fluid)fluid.getFluid(), (int)amount);
        }

        public void apply() {
            RecipeMatch rm = null;
            if (this.cast != null) {
                List validCasts = this.cast.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
                if (validCasts.isEmpty()) {
                    CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.cast.toString() + ". Substituting empty cast for recipe with output " + this.output.func_82833_r()));
                } else {
                    rm = validCasts.size() == 1 ? (((ItemStack)validCasts.get(0)).func_77960_j() == Short.MAX_VALUE ? RecipeMatch.of(validCasts, (int)this.output.func_190916_E()) : RecipeMatch.ofNBT((ItemStack)((ItemStack)validCasts.get(0)), (int)this.output.func_190916_E())) : RecipeMatch.of(validCasts, (int)this.output.func_190916_E());
                }
            }
            if (this.table) {
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipeTweaker(this.output, rm, new FluidStack(this.fluid, this.amount), this.time, this.consumeCast, false));
            } else {
                TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipeTweaker(this.output, rm, new FluidStack(this.fluid, this.amount), this.time, this.consumeCast, false));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class Remove
    extends BaseAction {
        private IItemStack output;
        private ILiquidStack input;
        private boolean table;

        protected Remove(IItemStack output, ILiquidStack input, boolean table) {
            super("Casting");
            this.output = output;
            this.input = input;
            this.table = table;
        }

        public void apply() {
            if (this.table) {
                REMOVED_RECIPES_TABLE.put(this.output, this.input);
            } else {
                REMOVED_RECIPES_BASIN.put(this.output, this.input);
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }
}

