/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.connection.LPNeighborTileEntity;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e0\rJ\t\u0010\u000f\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\bH\u00c2\u0003J\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e0\rJ\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnetwork/rs485/logisticspipes/world/WorldCoordinatesWrapper;", "", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;", "(Lnet/minecraft/tileentity/TileEntity;)V", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "getTileEntity", "()Lnet/minecraft/tileentity/TileEntity;", "allNeighborTileEntities", "", "Lnetwork/rs485/logisticspipes/connection/LPNeighborTileEntity;", "component1", "component2", "connectedTileEntities", "copy", "equals", "", "other", "getNeighbor", "direction", "Lnet/minecraft/util/EnumFacing;", "hashCode", "", "toString", "", "logisticspipes"})
public final class WorldCoordinatesWrapper {
    @NotNull
    private final World world;
    @NotNull
    private final BlockPos pos;

    public WorldCoordinatesWrapper(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        this.world = world;
        this.pos = pos;
    }

    public WorldCoordinatesWrapper(@NotNull TileEntity tileEntity) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        World world = tileEntity.func_145831_w();
        Intrinsics.checkNotNullExpressionValue(world, "tileEntity.world");
        BlockPos blockPos = tileEntity.func_174877_v();
        Intrinsics.checkNotNullExpressionValue(blockPos, "tileEntity.pos");
        this(world, blockPos);
    }

    @Nullable
    public final TileEntity getTileEntity() {
        return this.world.func_175625_s(this.pos);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LPNeighborTileEntity<TileEntity>> allNeighborTileEntities() {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue(EnumFacing.field_82609_l, "VALUES");
        Object[] $this$mapNotNull$iv = EnumFacing.field_82609_l;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            LPNeighborTileEntity<TileEntity> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            EnumFacing direction = (EnumFacing)element$iv$iv;
            boolean bl2 = false;
            if (this.getNeighbor(direction) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LPNeighborTileEntity<TileEntity>> connectedTileEntities() {
        void $this$filterTo$iv$iv;
        TileEntity pipe = this.getTileEntity();
        if (SimpleServiceLocator.pipeInformationManager.isNotAPipe(pipe)) {
            LogisticsPipes.log.warn("The coordinates didn't hold a pipe at all", new Throwable("Stack trace"));
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = this.allNeighborTileEntities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LPNeighborTileEntity adjacent = (LPNeighborTileEntity)element$iv$iv;
            boolean bl = false;
            if (!MainProxy.checkPipesConnections(pipe, adjacent.getTileEntity(), adjacent.getDirection())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final LPNeighborTileEntity<TileEntity> getNeighbor(@NotNull EnumFacing direction) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        TileEntity tileEntity = this.world.func_175625_s(this.pos.func_177972_a(direction));
        if (tileEntity == null) {
            return null;
        }
        TileEntity tileEntity2 = tileEntity;
        return new LPNeighborTileEntity<TileEntity>(tileEntity2, direction);
    }

    public int hashCode() {
        int result2 = this.world.hashCode();
        result2 = 31 * result2 + this.pos.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WorldCoordinatesWrapper)) {
            return false;
        }
        return Intrinsics.areEqual(this.world, ((WorldCoordinatesWrapper)other).world) && Intrinsics.areEqual(this.pos, ((WorldCoordinatesWrapper)other).pos);
    }

    @NotNull
    public String toString() {
        return "WorldCoordinatesWrapper(world=" + this.world + ", pos=" + this.pos + ')';
    }

    private final World component1() {
        return this.world;
    }

    private final BlockPos component2() {
        return this.pos;
    }

    @NotNull
    public final WorldCoordinatesWrapper copy(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return new WorldCoordinatesWrapper(world, pos);
    }

    public static /* synthetic */ WorldCoordinatesWrapper copy$default(WorldCoordinatesWrapper worldCoordinatesWrapper, World world, BlockPos blockPos, int n, Object object) {
        if ((n & 1) != 0) {
            world = worldCoordinatesWrapper.world;
        }
        if ((n & 2) != 0) {
            blockPos = worldCoordinatesWrapper.pos;
        }
        return worldCoordinatesWrapper.copy(world, blockPos);
    }
}

