/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableImage;
import network.rs485.logisticspipes.gui.guidebook.DrawableKt;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;
import network.rs485.logisticspipes.gui.guidebook.DrawableWordKt;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImageParagraph;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "alternativeText", "", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "image", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImage;", "(Ljava/util/List;Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImage;)V", "getImage", "()Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImage;", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "getHovered", "setChildrenPos", "", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "logisticspipes"})
public final class DrawableImageParagraph
extends DrawableParagraph {
    @NotNull
    private final List<DrawableWord> alternativeText;
    @NotNull
    private final DrawableImage image;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;

    public DrawableImageParagraph(@NotNull List<? extends DrawableWord> alternativeText, @NotNull DrawableImage image) {
        Intrinsics.checkNotNullParameter(alternativeText, "alternativeText");
        Intrinsics.checkNotNullParameter(image, "image");
        this.alternativeText = alternativeText;
        this.image = image;
        this.relativeBody = new MutableRectangle();
    }

    @NotNull
    public final DrawableImage getImage() {
        return this.image;
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.getRelativeBody().setPos(x, y);
        MutableRectangle mutableRectangle = this.getRelativeBody();
        Drawable drawable = this.getParent();
        Intrinsics.checkNotNull(drawable);
        mutableRectangle.setSize(drawable.getWidth(), 0);
        this.getRelativeBody().setSize(this.getRelativeBody().getRoundedWidth(), this.setChildrenPos());
        return TuplesKt.to(this.getRelativeBody().getRoundedWidth(), this.getRelativeBody().getRoundedHeight());
    }

    @Override
    public int setChildrenPos() {
        int currentY = 0;
        return currentY += this.image.getBroken() ? DrawableWordKt.splitAndInitialize(this.alternativeText, 5, currentY, this.getWidth() - 10, false) : ((Number)DrawableKt.getY(this.image.setPos(0, currentY))).intValue();
    }

    @Override
    @Nullable
    public Drawable getHovered(float mouseX, float mouseY) {
        Drawable drawable;
        if (this.image.getBroken()) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = this.alternativeText;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DrawableWord it = (DrawableWord)element$iv;
                    boolean bl = false;
                    if (!it.isMouseHovering(mouseX, mouseY)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            drawable = v0;
        } else {
            drawable = null;
        }
        return drawable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        if (this.image.getBroken()) {
            void $this$filterTo$iv$iv;
            super.draw(mouseX, mouseY, delta, visibleArea);
            Iterable $this$filter$iv = this.alternativeText;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DrawableWord it = (DrawableWord)element$iv$iv;
                boolean bl = false;
                if (!it.visible(visibleArea)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (DrawableWord drawableWord : (List)destination$iv$iv) {
                drawableWord.draw(mouseX, mouseY, delta, visibleArea);
                GuiDrawer.INSTANCE.drawOutlineRect(this.getAbsoluteBody(), MinecraftColor.WHITE.getColorCode());
            }
        } else {
            this.image.draw(mouseX, mouseY, delta, visibleArea);
        }
    }
}

