/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.font;

import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.ranges.CharRange;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import network.rs485.logisticspipes.gui.font.FontWrapperKt;
import network.rs485.logisticspipes.gui.font.IFont;
import network.rs485.logisticspipes.gui.font.IGlyph;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0 H\u0002J\u0006\u0010!\u001a\u00020\nJ\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0006J8\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\f\u00101\u001a\u00020\n*\u00020\nH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontWrapper;", "", "font", "Lnetwork/rs485/logisticspipes/gui/font/IFont;", "(Lnetwork/rs485/logisticspipes/gui/font/IFont;)V", "defaultChar", "", "getDefaultChar", "()C", "fontHeight", "", "getFontHeight", "()I", "fontLineOffset", "getFontLineOffset", "fontWidth", "getFontWidth", "fontXOffset", "getFontXOffset", "fontYOffset", "getFontYOffset", "glyphPosX", "", "glyphPosY", "maxTexSize", "textureIndex", "Llogisticspipes/kotlin/ranges/CharRange;", "textures", "", "getTextures", "()Ljava/util/List;", "allocateTextures", "Llogisticspipes/kotlin/Pair;", "getFontTextureSize", "getGlyph", "Lnetwork/rs485/logisticspipes/gui/font/IGlyph;", "c", "getGlyphX", "getGlyphY", "getTextureIndex", "setTexture", "", "bitmap", "Ljava/util/BitSet;", "texture", "x", "y", "width", "height", "powerOf2", "logisticspipes"})
public final class FontWrapper {
    @NotNull
    private final IFont font;
    @NotNull
    private Map<Character, Integer> glyphPosX;
    @NotNull
    private Map<Character, Integer> glyphPosY;
    @NotNull
    private Map<Integer, CharRange> textureIndex;
    private final char defaultChar;
    private final int maxTexSize;

    public FontWrapper(@NotNull IFont font) {
        Intrinsics.checkNotNullParameter(font, "font");
        this.font = font;
        this.glyphPosX = MapsKt.emptyMap();
        this.glyphPosY = MapsKt.emptyMap();
        this.textureIndex = MapsKt.emptyMap();
        this.defaultChar = this.font.getDefaultChar();
        this.maxTexSize = 512;
        this.allocateTextures();
    }

    @NotNull
    public final List<Integer> getTextures() {
        return CollectionsKt.toList((Iterable)this.textureIndex.keySet());
    }

    public final int getFontWidth() {
        return this.font.getWidth();
    }

    public final int getFontHeight() {
        return this.font.getHeight();
    }

    public final int getFontXOffset() {
        return this.font.getOffsetX();
    }

    public final int getFontYOffset() {
        return this.font.getOffsetY();
    }

    public final int getFontLineOffset() {
        return this.getFontHeight() + this.getFontYOffset();
    }

    public final char getDefaultChar() {
        return this.defaultChar;
    }

    private final void setTexture(BitSet bitmap, int texture, int x, int y, int width, int height) {
        FontWrapperKt.access$getBuffer$p().clear();
        int n = width * height;
        for (int i = 0; i < n; ++i) {
            FontWrapperKt.access$getBuffer$p().put(bitmap.get(i) ? -1 : 0);
        }
        FontWrapperKt.access$getBuffer$p().flip();
        GlStateManager.func_179144_i((int)texture);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)x, (int)y, (int)width, (int)height, (int)6408, (int)5121, (IntBuffer)FontWrapperKt.access$getBuffer$p());
    }

    private final Pair<Integer, Integer> allocateTextures() {
        Ref.IntRef currentWidth = new Ref.IntRef();
        Ref.IntRef currentHeight = new Ref.IntRef();
        Ref.IntRef currentRowMaxHeight = new Ref.IntRef();
        Ref.IntRef currentMaxHeight = new Ref.IntRef();
        Ref.IntRef currentMinOffset = new Ref.IntRef();
        Ref.IntRef currentTexId = new Ref.IntRef();
        char firstChar = ((Character)CollectionsKt.first((Iterable)this.font.getGlyphs().keySet())).charValue();
        Ref.CharRef startingChar = new Ref.CharRef();
        startingChar.element = firstChar;
        FontWrapper.allocateTextures$start(this, firstChar, startingChar, currentWidth, currentHeight, currentTexId);
        for (Map.Entry<Character, IGlyph> entry : this.font.getGlyphs().entrySet()) {
            char character = entry.getKey().charValue();
            IGlyph glyph = entry.getValue();
            if (currentWidth.element + glyph.getWidth() > this.maxTexSize) {
                FontWrapper.allocateTextures$startNewRow(currentMaxHeight, currentRowMaxHeight, currentHeight, this, currentWidth);
            }
            if (currentHeight.element + glyph.getHeight() > this.maxTexSize) {
                FontWrapper.allocateTextures$startNewTexture(firstChar, startingChar, currentWidth, currentHeight, currentTexId, this, character);
            }
            FontWrapper.allocateTextures$allocateGlyph(currentWidth, this, currentHeight, currentTexId, currentRowMaxHeight, currentMinOffset, character, glyph);
        }
        FontWrapper.allocateTextures$finish(this, startingChar, currentTexId);
        return TuplesKt.to(currentMaxHeight.element, currentMinOffset.element);
    }

    public final int getTextureIndex(char c) {
        Object v0;
        block1: {
            Iterable iterable = this.textureIndex.entrySet();
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                if (!((CharRange)entry.getValue()).contains(c)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? ((Number)entry.getKey()).intValue() : -1;
    }

    public final int getFontTextureSize() {
        return this.maxTexSize;
    }

    public final int getGlyphX(char c) {
        Integer n = this.glyphPosX.get(Character.valueOf(c));
        return n != null ? n : -1;
    }

    public final int getGlyphY(char c) {
        Integer n = this.glyphPosY.get(Character.valueOf(c));
        return n != null ? n : -1;
    }

    @Nullable
    public final IGlyph getGlyph(char c) {
        IGlyph iGlyph = this.font.getGlyphs().get(Character.valueOf(c));
        if (iGlyph == null) {
            iGlyph = this.font.getGlyphs().get(Character.valueOf(this.font.getDefaultChar()));
        }
        return iGlyph;
    }

    private final int powerOf2(int $this$powerOf2) {
        int n = $this$powerOf2 - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= Integer.MAX_VALUE ? Integer.MAX_VALUE : n + 1);
    }

    private static final int allocateTextures$generateTexture(FontWrapper this$0) {
        int texId = GL11.glGenTextures();
        GlStateManager.func_179144_i((int)texId);
        TextureUtil.func_110991_a((int)texId, (int)this$0.maxTexSize, (int)this$0.maxTexSize);
        LogisticsPipes.log.warn("Created new texture: " + texId);
        return texId;
    }

    private static final void allocateTextures$startNewRow(Ref.IntRef currentMaxHeight, Ref.IntRef currentRowMaxHeight, Ref.IntRef currentHeight, FontWrapper this$0, Ref.IntRef currentWidth) {
        currentMaxHeight.element = Math.max(currentMaxHeight.element, currentRowMaxHeight.element);
        currentHeight.element += this$0.powerOf2(currentRowMaxHeight.element);
        currentWidth.element = 0;
        currentRowMaxHeight.element = 0;
    }

    private static final void allocateTextures$addTextureRange(FontWrapper this$0, Ref.IntRef currentTexId, Ref.CharRef startingChar, char character) {
        this$0.textureIndex = MapsKt.plus(this$0.textureIndex, TuplesKt.to(currentTexId.element, new CharRange(startingChar.element, character)));
        LogisticsPipes.log.warn("Finished texture, covering characters " + startingChar.element + ".." + character);
    }

    private static final void allocateTextures$startNewTexture(char firstChar, Ref.CharRef startingChar, Ref.IntRef currentWidth, Ref.IntRef currentHeight, Ref.IntRef currentTexId, FontWrapper this$0, char character) {
        if (character != firstChar) {
            FontWrapper.allocateTextures$addTextureRange(this$0, currentTexId, startingChar, character);
        }
        startingChar.element = character;
        currentWidth.element = 0;
        currentHeight.element = 0;
        currentTexId.element = FontWrapper.allocateTextures$generateTexture(this$0);
    }

    private static final void allocateTextures$allocateGlyph(Ref.IntRef currentWidth, FontWrapper this$0, Ref.IntRef currentHeight, Ref.IntRef currentTexId, Ref.IntRef currentRowMaxHeight, Ref.IntRef currentMinOffset, char character, IGlyph glyph) {
        if (currentWidth.element + glyph.getWidth() > this$0.maxTexSize) {
            throw new IllegalStateException(("Cannot write a texture of width=" + glyph.getWidth() + " at x=" + currentWidth.element).toString());
        }
        if (currentHeight.element + glyph.getHeight() > this$0.maxTexSize) {
            throw new IllegalStateException(("Cannot write a texture of height=" + glyph.getHeight() + " at y=" + currentHeight.element).toString());
        }
        this$0.glyphPosX = MapsKt.plus(this$0.glyphPosX, TuplesKt.to(Character.valueOf(character), currentWidth.element));
        this$0.glyphPosY = MapsKt.plus(this$0.glyphPosY, TuplesKt.to(Character.valueOf(character), currentHeight.element));
        this$0.setTexture(glyph.getBitmap(), currentTexId.element, currentWidth.element, currentHeight.element, glyph.getWidth(), glyph.getHeight());
        currentWidth.element += this$0.powerOf2(glyph.getWidth());
        currentRowMaxHeight.element = Math.max(currentRowMaxHeight.element, glyph.getHeight());
        currentMinOffset.element = Math.min(currentMinOffset.element, glyph.getOffsetY());
    }

    private static final void allocateTextures$start(FontWrapper this$0, char firstChar, Ref.CharRef startingChar, Ref.IntRef currentWidth, Ref.IntRef currentHeight, Ref.IntRef currentTexId) {
        FontWrapper.allocateTextures$startNewTexture(firstChar, startingChar, currentWidth, currentHeight, currentTexId, this$0, ((Character)CollectionsKt.first((Iterable)this$0.font.getGlyphs().keySet())).charValue());
    }

    private static final void allocateTextures$finish(FontWrapper this$0, Ref.CharRef startingChar, Ref.IntRef currentTexId) {
        char lastChar = ((Character)CollectionsKt.last((Iterable)this$0.font.getGlyphs().keySet())).charValue();
        if (startingChar.element != lastChar) {
            FontWrapper.allocateTextures$addTextureRange(this$0, currentTexId, startingChar, lastChar);
        }
    }
}

