/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.NoWhenBranchMatchedException;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.ranges.IntProgression;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlin.text.StringsKt;
import logisticspipes.utils.Color;
import logisticspipes.utils.MinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.HorizontalAlignment;
import network.rs485.logisticspipes.gui.Texture;
import network.rs485.logisticspipes.gui.VerticalAlignment;
import network.rs485.logisticspipes.gui.font.LPFontRenderer;
import network.rs485.logisticspipes.gui.guidebook.DrawableKt;
import network.rs485.logisticspipes.gui.guidebook.Screen;
import network.rs485.logisticspipes.gui.widget.FuzzyItemSlot;
import network.rs485.logisticspipes.property.IBitSet;
import network.rs485.logisticspipes.util.FuzzyFlag;
import network.rs485.logisticspipes.util.FuzzyUtil;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.Rectangle;
import network.rs485.logisticspipes.util.math.BorderedRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;
import network.rs485.markdown.ElementKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001bJ.\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u001bJ0\u0010B\u001a\u0002042\u0006\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0004H\u0002J\u000e\u0010H\u001a\u0002042\u0006\u0010I\u001a\u000206J*\u0010J\u001a\u0002042\u0006\u0010I\u001a\u0002062\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040L2\u0006\u0010M\u001a\u00020NJ&\u0010O\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u0002062\u0006\u0010P\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u0004J\u000e\u0010Q\u001a\u0002042\u0006\u00105\u001a\u000206J\u0016\u0010R\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010S\u001a\u000206J\u001e\u0010T\u001a\u0002042\u0006\u0010C\u001a\u0002062\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u0004J\u0016\u0010W\u001a\u0002042\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YJ>\u0010[\u001a\u0002042\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010^\u001a\u00020YJ\u0016\u0010_\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020\u0004J\u0016\u0010`\u001a\u0002042\u0006\u0010C\u001a\u0002062\u0006\u0010@\u001a\u00020\u0004J\u0016\u0010a\u001a\u0002042\u0006\u0010b\u001a\u0002062\u0006\u0010c\u001a\u000206J<\u0010d\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0e2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010f\u001a\u00020Y2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020jJ\u001e\u0010k\u001a\u0002042\u0006\u0010C\u001a\u0002062\u0006\u0010l\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u0004J\b\u0010]\u001a\u000204H\u0002J\u000e\u0010n\u001a\u00020\u00042\u0006\u0010o\u001a\u00020pJ$\u0010q\u001a\u0002042\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040L2\u0006\u0010M\u001a\u00020NH\u0002J$\u0010s\u001a\u0002042\u0006\u0010t\u001a\u00020u2\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040LH\u0002J\u0010\u0010v\u001a\u0002042\u0006\u0010I\u001a\u000206H\u0002J>\u0010w\u001a\u0002042\u0012\u0010x\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0006\u0010y\u001a\u00020Y2\u0006\u0010@\u001a\u00020\u00042\b\b\u0002\u0010^\u001a\u00020Y2\u0006\u0010z\u001a\u00020\u001bH\u0002JL\u0010w\u001a\u0002042\u0012\u0010x\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0012\u0010{\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0006\u0010@\u001a\u00020\u00042\b\b\u0002\u0010^\u001a\u00020Y2\b\b\u0002\u0010z\u001a\u00020\u001bH\u0002J$\u0010|\u001a\u0002042\u0006\u0010t\u001a\u00020}2\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040LH\u0002J\"\u0010~\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020\u00042\b\b\u0002\u0010^\u001a\u00020YH\u0002J\u0018\u0010\u007f\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020\u0004H\u0002J!\u0010\u0080\u0001\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010c\u001a\u0002062\u0006\u0010@\u001a\u00020\u0004H\u0002J-\u0010\u0081\u0001\u001a\u0002042\u0006\u00105\u001a\u0002062\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0L2\u0006\u0010@\u001a\u00020\u0004H\u0002J!\u0010\u0082\u0001\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010c\u001a\u0002062\u0006\u0010@\u001a\u00020\u0004H\u0002J\u0011\u0010\u0083\u0001\u001a\u0002042\u0006\u0010c\u001a\u00020\u0010H\u0002J\u0014\u0010\\\u001a\u0002042\n\b\u0002\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\"\u0010\u0086\u0001\u001a\u00020\u0007*\u00020\u00072\u0013\u0010\u0087\u0001\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0LH\u0002J\u0015\u0010\u0088\u0001\u001a\u00020\u0007*\u00020\u00072\u0006\u0010@\u001a\u00020\u0004H\u0002J\"\u0010\u0089\u0001\u001a\u00020\u0007*\u00020\u00072\u0013\u0010\u0087\u0001\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0LH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010\"\u001a\u00020#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010!\u001a\u0004\b$\u0010%R\u000e\u0010'\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\n 2*\u0004\u0018\u00010101X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008a\u0001"}, d2={"Lnetwork/rs485/logisticspipes/gui/GuiDrawer;", "", "()V", "BORDER", "", "NORMAL_SLOT_SIZE", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "getBuffer", "()Lnet/minecraft/client/renderer/BufferBuilder;", "buttonBorderTextureDark", "Lnetwork/rs485/logisticspipes/util/Rectangle;", "buttonBorderTextureHovered", "buttonBorderTextureLight", "buttonBorderTextureNormal", "currentTexture", "Lnetwork/rs485/logisticspipes/gui/Texture;", "guiAtlas", "guiBackgroundTexture", "guiBlankTexture", "guiDarkPatternTexture", "guiGuidebookFrame", "guiGuidebookSlider", "guiHoveredPatternTexture", "guiLightPattern", "guiNormalPatternTexture", "isDrawing", "", "lpFontRenderer", "Lnetwork/rs485/logisticspipes/gui/font/LPFontRenderer;", "getLpFontRenderer", "()Lnetwork/rs485/logisticspipes/gui/font/LPFontRenderer;", "lpFontRenderer$delegate", "Llogisticspipes/kotlin/Lazy;", "mcFontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "getMcFontRenderer", "()Lnet/minecraft/client/gui/FontRenderer;", "mcFontRenderer$delegate", "slotBigTexture", "slotDiskTexture", "slotNormalTexture", "slotProgrammerTexture", "slotSmallTexture", "tessellator", "Lnet/minecraft/client/renderer/Tessellator;", "getTessellator", "()Lnet/minecraft/client/renderer/Tessellator;", "textureManager", "Lnet/minecraft/client/renderer/texture/TextureManager;", "logisticspipes.kotlin.jvm.PlatformType", "drawBorderedTile", "", "rect", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "hovered", "enabled", "light", "thickerBottomBorder", "drawCenteredString", "text", "", "x", "y", "color", "shadow", "drawGradientQuad", "area", "colorTopRight", "colorTopLeft", "colorBottomLeft", "colorBottomRight", "drawGuiBackground", "guiArea", "drawGuiContainerBackground", "topLeft", "Llogisticspipes/kotlin/Pair;", "container", "Lnet/minecraft/inventory/Container;", "drawGuiTexturedRect", "blend", "drawGuideBookBackground", "drawGuideBookFrame", "slider", "drawHorizontalGradientRect", "colorLeft", "colorRight", "drawInteractionIndicator", "mouseX", "", "mouseY", "drawLine", "start", "finish", "thickness", "drawOutlineRect", "drawRect", "drawSliderButton", "body", "texture", "drawTextTooltip", "", "z", "horizontalAlign", "Lnetwork/rs485/logisticspipes/gui/HorizontalAlignment;", "verticalAlign", "Lnetwork/rs485/logisticspipes/gui/VerticalAlignment;", "drawVerticalGradientRect", "colorTop", "colorBottom", "getFuzzyColor", "fuzzyFlag", "Lnetwork/rs485/logisticspipes/util/FuzzyFlag;", "putContainerSlots", "offset", "putFuzzySlot", "slot", "Lnetwork/rs485/logisticspipes/gui/widget/FuzzyItemSlot;", "putGuiBackgroundBase", "putLine", "from", "size", "vertical", "to", "putNormalSlot", "Lnet/minecraft/inventory/Slot;", "putOutlineQuad", "putQuad", "putRepeatingTexturedQuad", "putScaledTexturedQuad", "putTexturedQuad", "setTexture", "vertexFormats", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "pos", "point", "rgba", "tex", "logisticspipes"})
public final class GuiDrawer {
    @NotNull
    public static final GuiDrawer INSTANCE = new GuiDrawer();
    private static final int BORDER = 4;
    private static final int NORMAL_SLOT_SIZE = 18;
    @NotNull
    private static final Texture guiAtlas = new Texture(new ResourceLocation("logisticspipes", "textures/gui/gui.png"), 256);
    @NotNull
    private static final Texture guiNormalPatternTexture = new Texture(new ResourceLocation("logisticspipes", "textures/gui/normal.png"), 64);
    @NotNull
    private static final Texture guiLightPattern = new Texture(new ResourceLocation("logisticspipes", "textures/gui/light.png"), 64);
    @NotNull
    private static final Texture guiHoveredPatternTexture = new Texture(new ResourceLocation("logisticspipes", "textures/gui/blue.png"), 64);
    @NotNull
    private static final Texture guiDarkPatternTexture = new Texture(new ResourceLocation("logisticspipes", "textures/gui/dark.png"), 64);
    @NotNull
    private static Texture currentTexture = guiAtlas;
    @NotNull
    private static final Rectangle guiBackgroundTexture = new Rectangle(0, 96, 16, 16);
    @NotNull
    private static final Rectangle guiBlankTexture = new Rectangle(2, 2, 2, 2);
    @NotNull
    private static final Rectangle slotNormalTexture = new Rectangle(0, 112, 18, 18);
    @NotNull
    private static final Rectangle slotDiskTexture = new Rectangle(18, 112, 36, 18);
    @NotNull
    private static final Rectangle slotProgrammerTexture = new Rectangle(36, 112, 18, 18);
    @NotNull
    private static final Rectangle slotSmallTexture = new Rectangle(54, 112, 8, 8);
    @NotNull
    private static final Rectangle slotBigTexture = new Rectangle(0, 130, 26, 26);
    @NotNull
    private static final Rectangle guiGuidebookFrame = new Rectangle(0, 0, 64, 64);
    @NotNull
    private static final Rectangle guiGuidebookSlider = new Rectangle(96, 64, 16, 16);
    @NotNull
    private static final Rectangle buttonBorderTextureLight = new Rectangle(0, 64, 8, 8);
    @NotNull
    private static final Rectangle buttonBorderTextureNormal = new Rectangle(8, 64, 8, 8);
    @NotNull
    private static final Rectangle buttonBorderTextureDark = new Rectangle(0, 72, 8, 8);
    @NotNull
    private static final Rectangle buttonBorderTextureHovered = new Rectangle(8, 72, 8, 8);
    private static final TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
    private static boolean isDrawing;
    @NotNull
    private static final Lazy lpFontRenderer$delegate;
    @NotNull
    private static final Lazy mcFontRenderer$delegate;

    private GuiDrawer() {
    }

    private final Tessellator getTessellator() {
        Tessellator tessellator = Tessellator.func_178181_a();
        Intrinsics.checkNotNullExpressionValue(tessellator, "getInstance()");
        return tessellator;
    }

    private final BufferBuilder getBuffer() {
        BufferBuilder bufferBuilder = this.getTessellator().func_178180_c();
        Intrinsics.checkNotNullExpressionValue(bufferBuilder, "tessellator.buffer");
        return bufferBuilder;
    }

    @NotNull
    public final LPFontRenderer getLpFontRenderer() {
        Lazy lazy = lpFontRenderer$delegate;
        return (LPFontRenderer)lazy.getValue();
    }

    @NotNull
    public final FontRenderer getMcFontRenderer() {
        Lazy lazy = mcFontRenderer$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-mcFontRenderer>(...)");
        return (FontRenderer)t;
    }

    public final int getFuzzyColor(@NotNull FuzzyFlag fuzzyFlag) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fuzzyFlag, "fuzzyFlag");
        switch (WhenMappings.$EnumSwitchMapping$0[fuzzyFlag.ordinal()]) {
            case 1: {
                n = Color.FUZZY_IGNORE_DAMAGE_COLOR.getValue();
                break;
            }
            case 2: {
                n = Color.FUZZY_IGNORE_NBT_COLOR.getValue();
                break;
            }
            case 3: {
                n = Color.FUZZY_ORE_DICT_COLOR.getValue();
                break;
            }
            case 4: {
                n = Color.FUZZY_ORE_CATEGORY_COLOR.getValue();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void drawGuiContainerBackground(@NotNull IRectangle guiArea, @NotNull Pair<Integer, Integer> topLeft, @NotNull Container container) {
        Intrinsics.checkNotNullParameter(guiArea, "guiArea");
        Intrinsics.checkNotNullParameter(topLeft, "topLeft");
        Intrinsics.checkNotNullParameter(container, "container");
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        this.putGuiBackgroundBase(guiArea);
        this.putContainerSlots(topLeft, container);
        this.finish();
    }

    public final void drawGuiBackground(@NotNull IRectangle guiArea) {
        Intrinsics.checkNotNullParameter(guiArea, "guiArea");
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        this.putGuiBackgroundBase(guiArea);
        this.finish();
    }

    private final void putGuiBackgroundBase(IRectangle guiArea) {
        List<IRectangle> borderedGuiQuads = new BorderedRectangle<IRectangle>(guiArea, 4).getQuads();
        List<IRectangle> borderedTexQuads = new BorderedRectangle<IRectangle>(guiBackgroundTexture, 4).getQuads();
        Iterator<IRectangle> iterator2 = borderedGuiQuads.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IRectangle quad = iterator2.next();
            this.putTexturedQuad(quad, borderedTexQuads.get(i), -1);
        }
    }

    private final void putContainerSlots(Pair<Integer, Integer> offset, Container container) {
        for (Slot slot : container.field_75151_b) {
            if (slot instanceof FuzzyItemSlot) {
                Intrinsics.checkNotNullExpressionValue(slot, "slot");
                this.putFuzzySlot((FuzzyItemSlot)slot, offset);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(slot, "slot");
            this.putNormalSlot(slot, offset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void putFuzzySlot(FuzzyItemSlot slot, Pair<Integer, Integer> offset) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        this.putNormalSlot(slot, offset);
        Pair<Integer, Integer> slotTopLeft = TuplesKt.to(slot.field_75223_e + ((Number)DrawableKt.getX(offset)).intValue(), slot.field_75221_f + ((Number)DrawableKt.getY(offset)).intValue());
        IBitSet flags = slot.getFlagGetter().invoke();
        Iterable $this$filter$iv = slot.getUsedFlags();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FuzzyFlag flag = (FuzzyFlag)((Object)element$iv$iv);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)flag, "flag");
            if (!FuzzyUtil.INSTANCE.get(flags, flag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FuzzyFlag flag = (FuzzyFlag)((Object)element$iv);
            boolean bl = false;
            int color = INSTANCE.getFuzzyColor(flag);
            switch (WhenMappings.$EnumSwitchMapping$0[flag.ordinal()]) {
                case 1: {
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, false, 8, null);
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, true, 8, null);
                    break;
                }
                case 2: {
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() + 16.0f)), 9.0f, color, 0.0f, false, 8, null);
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() + 16.0f)), -8.0f, color, 0.0f, true, 8, null);
                    break;
                }
                case 3: {
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, false, 8, null);
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, true, 8, null);
                    break;
                }
                case 4: {
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, false, 8, null);
                    GuiDrawer.putLine$default(INSTANCE, TuplesKt.to(Float.valueOf(((Number)DrawableKt.getX(slotTopLeft)).floatValue() - 1.0f), Float.valueOf(((Number)DrawableKt.getY(slotTopLeft)).floatValue() - 1.0f)), 9.0f, color, 0.0f, true, 8, null);
                }
            }
        }
    }

    private final void putNormalSlot(Slot slot, Pair<Integer, Integer> offset) {
        this.putTexturedQuad(new MutableRectangle(slot.field_75223_e + ((Number)DrawableKt.getX(offset)).intValue(), slot.field_75221_f + ((Number)DrawableKt.getY(offset)).intValue(), 18, 18).translate(-1), slotNormalTexture, MinecraftColor.WHITE.getColorCode());
    }

    public final void drawGuiTexturedRect(@NotNull IRectangle rect, @NotNull IRectangle text, boolean blend, int color) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        Intrinsics.checkNotNullParameter(text, "text");
        if (blend) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        } else {
            GlStateManager.func_179084_k();
        }
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        this.putTexturedQuad(rect, text, color);
        this.finish();
        if (blend) {
            GlStateManager.func_179084_k();
        }
    }

    public final void drawBorderedTile(@NotNull IRectangle rect, boolean hovered, boolean enabled, boolean light, boolean thickerBottomBorder) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int border = 2;
        int bottomBorder = thickerBottomBorder ? border + 1 : border;
        Pair<Texture, Rectangle> pair = !enabled ? TuplesKt.to(guiDarkPatternTexture, buttonBorderTextureDark) : (hovered ? TuplesKt.to(guiHoveredPatternTexture, buttonBorderTextureHovered) : (light ? TuplesKt.to(guiLightPattern, buttonBorderTextureLight) : TuplesKt.to(guiNormalPatternTexture, buttonBorderTextureNormal)));
        Texture buttonBackgroundTexture = pair.component1();
        Rectangle buttonBorderTexture = pair.component2();
        this.setTexture(buttonBackgroundTexture);
        GuiDrawer.start$default(this, null, 1, null);
        this.putScaledTexturedQuad(rect, TuplesKt.to(Float.valueOf(0.0f), Float.valueOf(0.0f)), -1);
        this.finish();
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        List<IRectangle> borderedGuiQuads = new BorderedRectangle<IRectangle>(rect, border, border, bottomBorder, border).getBorderQuads();
        List<IRectangle> borderedTexQuads = new BorderedRectangle<IRectangle>(buttonBorderTexture, border, border, border, border).getBorderQuads();
        Iterator<IRectangle> iterator2 = borderedGuiQuads.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IRectangle quad = iterator2.next();
            this.putTexturedQuad(quad, borderedTexQuads.get(i), -1);
        }
        this.finish();
        GlStateManager.func_179084_k();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawGuideBookFrame(@NotNull IRectangle rect, @NotNull IRectangle slider) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(rect, "rect");
        Intrinsics.checkNotNullParameter(slider, "slider");
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BorderedRectangle<IRectangle> borderedGui = new BorderedRectangle<IRectangle>(rect, 24);
        List<IRectangle> borderedGuiTexQuads = new BorderedRectangle<IRectangle>(guiGuidebookFrame, 24).getBorderQuads();
        Iterable $this$filter$iv = new BorderedRectangle<IRectangle>(slider, 1, 0, 1, 0).getQuads();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            IRectangle it = (IRectangle)element$iv$iv;
            boolean bl = false;
            if (!((double)it.getWidth() > 0.5 && (double)it.getHeight() > 0.5)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List borderedSlider = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = new BorderedRectangle<IRectangle>(guiGuidebookSlider, 1, 0, 1, 0).getQuads();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IRectangle it = (IRectangle)element$iv$iv;
            boolean bl = false;
            if (!((double)it.getWidth() > 0.5 && (double)it.getHeight() > 0.5)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List borderedSliderTexQuads = (List)destination$iv$iv2;
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        Iterator iterator2 = CollectionsKt.plus((Collection)borderedGui.getBorderQuads(), (Iterable)borderedSlider).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IRectangle quad = (IRectangle)iterator2.next();
            this.putTexturedQuad(quad, (IRectangle)CollectionsKt.plus((Collection)borderedGuiTexQuads, (Iterable)borderedSliderTexQuads).get(i), -1);
        }
        this.finish();
        GlStateManager.func_179084_k();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawTextTooltip(@NotNull List<String> text, int x, int y, float z, @NotNull HorizontalAlignment horizontalAlign, @NotNull VerticalAlignment verticalAlign) {
        void $this$fold$iv;
        int n;
        int n2;
        Object object;
        block28: {
            block27: {
                boolean bl;
                block26: {
                    Intrinsics.checkNotNullParameter(text, "text");
                    Intrinsics.checkNotNullParameter((Object)horizontalAlign, "horizontalAlign");
                    Intrinsics.checkNotNullParameter((Object)verticalAlign, "verticalAlign");
                    if (text.isEmpty()) break block27;
                    Iterable $this$all$iv = text;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (StringsKt.isBlank(it)) continue;
                            bl = false;
                            break block26;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block28;
            }
            return;
        }
        int border = 4;
        int horizontalPadding = 2;
        int verticalPadding = 1;
        Iterator<Object> iterator2 = ((Iterable)text).iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = (String)iterator2.next();
            boolean bl = false;
            it = INSTANCE.getLpFontRenderer().getStringWidth((String)it);
            while (iterator2.hasNext()) {
                Object it2 = (String)iterator2.next();
                $i$a$-maxOfOrNull-GuiDrawer$drawTextTooltip$outerArea$1 = false;
                it2 = INSTANCE.getLpFontRenderer().getStringWidth((String)it2);
                if (it.compareTo(it2) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n3 = (Integer)object;
        int n4 = text.size() * LPFontRenderer.getFontHeight$default(this.getLpFontRenderer(), 0.0f, 1, null) + 2 * (verticalPadding + border);
        int n5 = (n3 != null ? n3 : 0) + 2 * (border + horizontalPadding);
        MutableRectangle outerArea = new MutableRectangle(n5, n4);
        switch (WhenMappings.$EnumSwitchMapping$1[horizontalAlign.ordinal()]) {
            case 1: {
                n2 = x - outerArea.getRoundedWidth() / 2;
                break;
            }
            case 2: {
                n2 = x;
                break;
            }
            case 3: {
                n2 = x - outerArea.getRoundedWidth();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$2[verticalAlign.ordinal()]) {
            case 1: {
                n = y - outerArea.getRoundedHeight() / 2;
                break;
            }
            case 2: {
                n = y;
                break;
            }
            case 3: {
                n = y - outerArea.getRoundedHeight();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        outerArea.setPos(n2, n);
        if (outerArea.getX0() < 0.0f) {
            MutableRectangle.translate$default(outerArea, -outerArea.getX0(), 0.0f, 2, null);
        }
        if (outerArea.getX1() > (float)Screen.INSTANCE.getAbsoluteBody().getRoundedWidth()) {
            MutableRectangle.translate$default(outerArea, (float)Screen.INSTANCE.getAbsoluteBody().getRoundedWidth() - outerArea.getX1(), 0.0f, 2, null);
        }
        if (outerArea.getY0() < 0.0f) {
            MutableRectangle.translate$default(outerArea, 0.0f, -outerArea.getY0(), 1, null);
        }
        if (outerArea.getY1() > (float)Screen.INSTANCE.getAbsoluteBody().getRoundedHeight()) {
            MutableRectangle.translate$default(outerArea, 0.0f, (float)Screen.INSTANCE.getAbsoluteBody().getRoundedHeight() - outerArea.getY1(), 1, null);
        }
        List<IRectangle> borderedTooltipQuads = new BorderedRectangle<IRectangle>(outerArea, border).getQuads();
        List<IRectangle> borderedTexQuads = new BorderedRectangle<IRectangle>(new Rectangle(112, 32, 16, 16), border).getQuads();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)z);
        GlStateManager.func_179141_d();
        this.setTexture(guiAtlas);
        GuiDrawer.start$default(this, null, 1, null);
        iterator2 = borderedTooltipQuads.iterator();
        int it = 0;
        while (iterator2.hasNext()) {
            int i = it++;
            IRectangle quad = (IRectangle)iterator2.next();
            this.putTexturedQuad(quad, borderedTexQuads.get(i), -1);
        }
        this.finish();
        int textX = outerArea.getRoundedX() + border + horizontalPadding;
        int textY = outerArea.getRoundedY() + border + verticalPadding;
        Iterable i = text;
        int initial$iv = textY;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void line;
            String string = (String)element$iv;
            int yOffset = accumulator$iv;
            boolean bl = false;
            accumulator$iv = INSTANCE.getLpFontRenderer().drawString((String)line, textX, yOffset, ElementKt.getDefaultDrawableState().getColor(), ElementKt.getDefaultDrawableState().getFormat(), 1.0f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-z));
    }

    public final void drawGuideBookBackground(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        BorderedRectangle<IRectangle> borderedGui = new BorderedRectangle<IRectangle>(rect, 24);
        this.setTexture(guiDarkPatternTexture);
        GuiDrawer.start$default(this, null, 1, null);
        this.putScaledTexturedQuad(borderedGui.getInner().translate(-8).grow(16), TuplesKt.to(Float.valueOf(0.0f), Float.valueOf(0.0f)), -1);
        this.finish();
    }

    public final void drawSliderButton(@NotNull IRectangle body, @NotNull IRectangle texture) {
        MutableRectangle mutableRectangle;
        MutableRectangle mutableRectangle2;
        Intrinsics.checkNotNullParameter(body, "body");
        Intrinsics.checkNotNullParameter(texture, "texture");
        this.setTexture(guiAtlas);
        MutableRectangle $this$drawSliderButton_u24lambda_u2d7 = mutableRectangle2 = MutableRectangle.Companion.fromRectangle(body);
        boolean bl = false;
        $this$drawSliderButton_u24lambda_u2d7.grow(4, 0);
        $this$drawSliderButton_u24lambda_u2d7.translate(-2, 0);
        int n = 2;
        IRectangle iRectangle = mutableRectangle2;
        BorderedRectangle<IRectangle> quads = new BorderedRectangle<IRectangle>(iRectangle, n);
        MutableRectangle $this$drawSliderButton_u24lambda_u2d8 = mutableRectangle = MutableRectangle.Companion.fromRectangle(texture);
        boolean bl2 = false;
        $this$drawSliderButton_u24lambda_u2d8.grow(4, 0);
        $this$drawSliderButton_u24lambda_u2d8.translate(-2, 0);
        int n2 = 2;
        IRectangle iRectangle2 = mutableRectangle;
        BorderedRectangle<IRectangle> textures = new BorderedRectangle<IRectangle>(iRectangle2, n2);
        GuiDrawer.start$default(this, null, 1, null);
        this.putTexturedQuad(quads.getTop(), textures.getTop(), -1);
        this.putRepeatingTexturedQuad(quads.getInner(), textures.getInner(), -1);
        this.putTexturedQuad(quads.getBottom(), textures.getBottom(), -1);
        this.finish();
    }

    public final void drawCenteredString(@NotNull String text, int x, int y, int color, boolean shadow) {
        Intrinsics.checkNotNullParameter(text, "text");
        int xOffset = this.getMcFontRenderer().func_78256_a(text) / 2;
        this.getMcFontRenderer().func_175065_a(text, (float)x - (float)xOffset, (float)y, color, shadow);
    }

    public final void drawInteractionIndicator(float mouseX, float mouseY) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        VertexFormat vertexFormat = DefaultVertexFormats.field_181706_f;
        Intrinsics.checkNotNullExpressionValue(vertexFormat, "POSITION_COLOR");
        this.start(vertexFormat);
        this.putQuad(new Rectangle(TuplesKt.to(Float.valueOf(mouseX + 4.0f), Float.valueOf(mouseY - 5.0f)), TuplesKt.to(Float.valueOf(mouseX + 5.0f), Float.valueOf(mouseY - 2.0f))), MinecraftColor.WHITE.getColorCode());
        this.putQuad(new Rectangle(TuplesKt.to(Float.valueOf(mouseX + 3.0f), Float.valueOf(mouseY - 4.0f)), TuplesKt.to(Float.valueOf(mouseX + 6.0f), Float.valueOf(mouseY - 3.0f))), MinecraftColor.WHITE.getColorCode());
        this.finish();
        GlStateManager.func_179098_w();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
    }

    public final void drawRect(@NotNull IRectangle area, int color) {
        Intrinsics.checkNotNullParameter(area, "area");
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        VertexFormat vertexFormat = DefaultVertexFormats.field_181706_f;
        Intrinsics.checkNotNullExpressionValue(vertexFormat, "POSITION_COLOR");
        this.start(vertexFormat);
        this.putQuad(area, color);
        this.finish();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public final void drawHorizontalGradientRect(@NotNull IRectangle area, int colorLeft, int colorRight) {
        Intrinsics.checkNotNullParameter(area, "area");
        this.drawGradientQuad(area, colorRight, colorLeft, colorLeft, colorRight);
    }

    public final void drawVerticalGradientRect(@NotNull IRectangle area, int colorTop, int colorBottom) {
        Intrinsics.checkNotNullParameter(area, "area");
        this.drawGradientQuad(area, colorTop, colorTop, colorBottom, colorBottom);
    }

    public final void drawLine(@NotNull Pair<Float, Float> start, @NotNull Pair<Float, Float> finish, int color, float thickness) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(finish, "finish");
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        VertexFormat vertexFormat = DefaultVertexFormats.field_181706_f;
        Intrinsics.checkNotNullExpressionValue(vertexFormat, "POSITION_COLOR");
        this.start(vertexFormat);
        GuiDrawer.putLine$default(this, start, finish, color, thickness, false, 16, null);
        this.finish();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public final void drawOutlineRect(@NotNull IRectangle rect, int color) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        VertexFormat vertexFormat = DefaultVertexFormats.field_181706_f;
        Intrinsics.checkNotNullExpressionValue(vertexFormat, "POSITION_COLOR");
        this.start(vertexFormat);
        GuiDrawer.putOutlineQuad$default(this, rect, color, 0.0f, 4, null);
        this.finish();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private final void drawGradientQuad(IRectangle area, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        VertexFormat vertexFormat = DefaultVertexFormats.field_181706_f;
        Intrinsics.checkNotNullExpressionValue(vertexFormat, "POSITION_COLOR");
        this.start(vertexFormat);
        this.rgba(this.pos(this.getBuffer(), area.getTopRight()), colorTopRight).func_181675_d();
        this.rgba(this.pos(this.getBuffer(), area.getTopLeft()), colorTopLeft).func_181675_d();
        this.rgba(this.pos(this.getBuffer(), area.getBottomLeft()), colorBottomRight).func_181675_d();
        this.rgba(this.pos(this.getBuffer(), area.getBottomRight()), colorBottomLeft).func_181675_d();
        this.finish();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private final void putRepeatingTexturedQuad(IRectangle rect, IRectangle texture, int color) {
        MutableRectangle tile = new MutableRectangle(rect.getLeft(), rect.getTop(), Float.min(rect.getWidth(), texture.getWidth()), Float.min(rect.getHeight(), texture.getHeight()));
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, rect.getRoundedWidth()), tile.getRoundedWidth());
        int x = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
            while (true) {
                IntProgression intProgression2 = RangesKt.step(RangesKt.until(0, rect.getRoundedHeight()), tile.getRoundedHeight());
                int y = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && y <= n3 || n4 < 0 && n3 <= y) {
                    while (true) {
                        this.putScaledTexturedQuad(rect.contains(tile) ? (IRectangle)tile : rect.overlap(tile), texture.getTopLeft(), color);
                        tile.translate(0.0f, tile.getHeight());
                        if (y == n3) break;
                        y += n4;
                    }
                }
                tile.setPos(tile.getLeft(), rect.getTop());
                tile.translate(tile.getWidth(), 0.0f);
                if (x == n) break;
                x += n2;
            }
        }
    }

    private final void putScaledTexturedQuad(IRectangle rect, Pair<Float, Float> texture, int color) {
        this.putTexturedQuad(rect, new Rectangle(((Number)texture.getFirst()).floatValue(), ((Number)texture.getSecond()).floatValue(), rect.getWidth(), rect.getHeight()), color);
    }

    private final void putTexturedQuad(IRectangle rect, IRectangle texture, int color) {
        if (Intrinsics.areEqual(this.getBuffer().func_178973_g(), DefaultVertexFormats.field_181709_i)) {
            IRectangle scaledUV = texture.scaled(currentTexture.getFactor());
            this.rgba(this.tex(this.pos(this.getBuffer(), rect.getTopRight()), scaledUV.getTopRight()), color).func_181675_d();
            this.rgba(this.tex(this.pos(this.getBuffer(), rect.getTopLeft()), scaledUV.getTopLeft()), color).func_181675_d();
            this.rgba(this.tex(this.pos(this.getBuffer(), rect.getBottomLeft()), scaledUV.getBottomLeft()), color).func_181675_d();
            this.rgba(this.tex(this.pos(this.getBuffer(), rect.getBottomRight()), scaledUV.getBottomRight()), color).func_181675_d();
        }
    }

    private final void putLine(Pair<Float, Float> from, Pair<Float, Float> to, int color, float thickness, boolean vertical) {
        if (!vertical) {
            this.putQuad(new Rectangle(from, TuplesKt.to(to.getFirst(), Float.valueOf(((Number)to.getSecond()).floatValue() + thickness))), color);
        } else {
            this.putQuad(new Rectangle(from, TuplesKt.to(Float.valueOf(((Number)to.getFirst()).floatValue() + thickness), to.getSecond())), color);
        }
    }

    static /* synthetic */ void putLine$default(GuiDrawer guiDrawer, Pair pair, Pair pair2, int n, float f, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f = 1.0f;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        guiDrawer.putLine((Pair<Float, Float>)pair, pair2, n, f, bl);
    }

    private final void putLine(Pair<Float, Float> from, float size, int color, float thickness, boolean vertical) {
        Pair<Float, Float> newFrom = from;
        float newSize = size;
        if (size == 0.0f) {
            return;
        }
        if (size < 0.0f && vertical) {
            newFrom = TuplesKt.to(DrawableKt.getX(newFrom), Float.valueOf(((Number)DrawableKt.getY(newFrom)).floatValue() + newSize));
            newSize = Math.abs(newSize);
        }
        this.putLine(newFrom, TuplesKt.to(Float.valueOf(!vertical ? ((Number)DrawableKt.getX(newFrom)).floatValue() + newSize : ((Number)DrawableKt.getX(newFrom)).floatValue()), Float.valueOf(!vertical ? ((Number)DrawableKt.getY(newFrom)).floatValue() : ((Number)DrawableKt.getY(newFrom)).floatValue() + newSize)), color, thickness, vertical);
    }

    static /* synthetic */ void putLine$default(GuiDrawer guiDrawer, Pair pair, float f, int n, float f2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f2 = 1.0f;
        }
        guiDrawer.putLine((Pair<Float, Float>)pair, f, n, f2, bl);
    }

    private final void putOutlineQuad(IRectangle rect, int color, float thickness) {
        GuiDrawer.putLine$default(this, rect.getTopLeft(), rect.getTopRight(), color, thickness, false, 16, null);
        GuiDrawer.putLine$default(this, rect.getBottomLeft(), rect.getBottomRight(), color, thickness, false, 16, null);
        this.putLine(rect.getTopLeft(), rect.getBottomLeft(), color, thickness, true);
        this.putLine(rect.getTopRight(), rect.getBottomRight(), color, thickness, true);
    }

    static /* synthetic */ void putOutlineQuad$default(GuiDrawer guiDrawer, IRectangle iRectangle, int n, float f, int n2, Object object) {
        if ((n2 & 4) != 0) {
            f = 1.0f;
        }
        guiDrawer.putOutlineQuad(iRectangle, n, f);
    }

    private final void putQuad(IRectangle rect, int color) {
        if (Intrinsics.areEqual(this.getBuffer().func_178973_g(), DefaultVertexFormats.field_181709_i)) {
            this.putTexturedQuad(rect, guiBlankTexture, color);
        } else if (Intrinsics.areEqual(this.getBuffer().func_178973_g(), DefaultVertexFormats.field_181706_f)) {
            this.rgba(this.pos(this.getBuffer(), rect.getTopRight()), color).func_181675_d();
            this.rgba(this.pos(this.getBuffer(), rect.getTopLeft()), color).func_181675_d();
            this.rgba(this.pos(this.getBuffer(), rect.getBottomLeft()), color).func_181675_d();
            this.rgba(this.pos(this.getBuffer(), rect.getBottomRight()), color).func_181675_d();
        }
    }

    private final void start(VertexFormat vertexFormats) {
        if (!isDrawing) {
            this.getBuffer().func_181668_a(7, vertexFormats);
            isDrawing = true;
        }
    }

    static /* synthetic */ void start$default(GuiDrawer guiDrawer, VertexFormat vertexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            VertexFormat vertexFormat2 = DefaultVertexFormats.field_181709_i;
            Intrinsics.checkNotNullExpressionValue(vertexFormat2, "POSITION_TEX_COLOR");
            vertexFormat = vertexFormat2;
        }
        guiDrawer.start(vertexFormat);
    }

    private final void finish() {
        if (isDrawing) {
            this.getTessellator().func_78381_a();
            isDrawing = false;
        }
    }

    private final void setTexture(Texture texture) {
        currentTexture = texture;
        textureManager.func_110577_a(currentTexture.getResource());
    }

    private final BufferBuilder rgba(BufferBuilder $this$rgba, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        BufferBuilder bufferBuilder = $this$rgba.func_181669_b(r, g, b, a);
        Intrinsics.checkNotNullExpressionValue(bufferBuilder, "this.color(r, g, b, a)");
        return bufferBuilder;
    }

    private final BufferBuilder tex(BufferBuilder $this$tex, Pair<Float, Float> point) {
        BufferBuilder bufferBuilder = $this$tex.func_187315_a((double)((Number)point.getFirst()).floatValue(), (double)((Number)point.getSecond()).floatValue());
        Intrinsics.checkNotNullExpressionValue(bufferBuilder, "tex(point.first.toDouble\u2026 point.second.toDouble())");
        return bufferBuilder;
    }

    private final BufferBuilder pos(BufferBuilder $this$pos, Pair<Float, Float> point) {
        BufferBuilder bufferBuilder = $this$pos.func_181662_b((double)((Number)point.getFirst()).floatValue(), (double)((Number)point.getSecond()).floatValue(), 0.0);
        Intrinsics.checkNotNullExpressionValue(bufferBuilder, "pos(point.first.toDouble\u2026t.second.toDouble(), 0.0)");
        return bufferBuilder;
    }

    static {
        lpFontRenderer$delegate = LazyKt.lazy(lpFontRenderer.2.INSTANCE);
        mcFontRenderer$delegate = LazyKt.lazy(mcFontRenderer.2.INSTANCE);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[FuzzyFlag.values().length];
            nArray[FuzzyFlag.IGNORE_DAMAGE.ordinal()] = 1;
            nArray[FuzzyFlag.IGNORE_NBT.ordinal()] = 2;
            nArray[FuzzyFlag.USE_ORE_DICT.ordinal()] = 3;
            nArray[FuzzyFlag.USE_ORE_CATEGORY.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.CENTER.ordinal()] = 1;
            nArray[HorizontalAlignment.LEFT.ordinal()] = 2;
            nArray[HorizontalAlignment.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[VerticalAlignment.values().length];
            nArray[VerticalAlignment.CENTER.ordinal()] = 1;
            nArray[VerticalAlignment.TOP.ordinal()] = 2;
            nArray[VerticalAlignment.BOTTOM.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

