/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.transactor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.utils.transactor.IInvSlot;
import logisticspipes.utils.transactor.InventoryIterator;
import logisticspipes.utils.transactor.Transactor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class TransactorSimple
extends Transactor {
    protected IItemHandler inventory;

    public TransactorSimple(IItemHandler inventory) {
        this.inventory = inventory;
    }

    @Override
    public int inject(@Nonnull ItemStack stack, EnumFacing orientation, boolean doAdd) {
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inventory.getSlots());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inventory.getSlots());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot().func_190926_b()) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        injected = this.tryPut(stack, emptySlots, injected, doAdd);
        return injected;
    }

    private int tryPut(@Nonnull ItemStack stack, List<IInvSlot> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        if (realInjected >= stack.func_190916_E()) {
            return realInjected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (!stackInSlot.func_190926_b() && !this.canStacksMerge(stackInSlot, stack) || (used = this.addToSlot(slot, stack, realInjected, doAdd)) <= 0 || (realInjected += used) < stack.func_190916_E()) continue;
            return realInjected;
        }
        return realInjected;
    }

    protected int addToSlot(IInvSlot slot, @Nonnull ItemStack stack, int injected, boolean doAdd) {
        int available = stack.func_190916_E() - injected;
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(available);
        ItemStack rest = slot.insertItem(newStack, !doAdd);
        return available - rest.func_190916_E();
    }

    private boolean canStacksMerge(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

