/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import net.minecraft.util.math.Vec3d;

public class Vector3d {
    public double x;
    public double y;
    public double z;

    public Vector3d(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public static Vector3d getFromAngles(double Yaw, double Pitch) {
        Vector3d vector = new Vector3d();
        vector.x = Math.cos(Yaw) * Math.cos(Pitch);
        vector.y = Math.sin(Pitch);
        vector.z = Math.sin(Yaw) * Math.cos(Pitch);
        return vector;
    }

    public Vector3d multiply(double i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public double abs() {
        return Math.hypot(this.x, Math.hypot(this.y, this.z));
    }

    public Vector3d add(Vector3d vector, double factor) {
        Vector3d lVector = vector.clone().makeVectorLength(factor);
        this.x += lVector.x;
        this.y += lVector.y;
        this.z += lVector.z;
        return this;
    }

    public Vector3d add(Vector3d vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3d sub(Vector3d vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3d getOrtogonal(Double pX, Double pY, Double pZ) {
        if (pX != null && pY != null && pZ != null || pX == null && pY == null || pY == null && pZ == null || pX == null && pZ == null) {
            throw new UnsupportedOperationException("One, only one parameter needs to be null");
        }
        Vector3d answer = new Vector3d();
        if (pX == null) {
            answer.x = (-pY.doubleValue() * this.y - pZ * this.z) / this.x;
            answer.y = pY;
            answer.z = pZ;
        } else if (pY == null) {
            answer.x = pX;
            answer.y = (-pX.doubleValue() * this.x - pZ * this.z) / this.y;
            answer.z = pZ;
        } else if (pZ == null) {
            answer.x = pX;
            answer.y = pY;
            answer.z = (-pX.doubleValue() * this.x - pY * this.y) / this.z;
        }
        return answer;
    }

    public Vector3d makeVectorLength(double length) {
        double divide = Math.sqrt(Math.pow(this.abs(), 2.0) / Math.pow(length, 2.0));
        double multiply = 1.0 / divide;
        this.x *= multiply;
        this.y *= multiply;
        this.z *= multiply;
        return this;
    }

    public String toString() {
        return String.format("[%s,%s,%s](%s)", this.x, this.y, this.z, this.abs());
    }

    public Vector3d clone() {
        Vector3d vector = new Vector3d();
        vector.x = this.x;
        vector.y = this.y;
        vector.z = this.z;
        return vector;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vector3d vector3d) {
        this.set(vector3d.x, vector3d.y, vector3d.z);
    }

    public void cross(Vector3d v1, Vector3d v2) {
        this.x = v1.y * v2.z - v1.z * v2.y;
        this.y = v2.x * v1.z - v2.z * v1.x;
        this.z = v1.x * v2.y - v1.y * v2.x;
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d() {
    }
}

