/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.SimpleGraphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiGraphics {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot.png");
    public static final ResourceLocation BIG_SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot-big.png");
    public static final ResourceLocation SMALL_SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot-small.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/GuiBackground.png");
    public static final ResourceLocation LOCK_ICON = new ResourceLocation("logisticspipes", "textures/gui/lock.png");
    public static final ResourceLocation LINES_ICON = new ResourceLocation("logisticspipes", "textures/gui/lines.png");
    public static final ResourceLocation STATS_ICON = new ResourceLocation("logisticspipes", "textures/gui/stats.png");
    public static final ResourceLocation SLOT_DISK_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot_disk.png");
    public static final ResourceLocation SLOT_PROGRAMMER_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot_programmer.png");
    public static float zLevel = 0.0f;

    private GuiGraphics() {
    }

    public static void drawDurabilityBar(@Nonnull ItemStack itemstack, int x, int y, double zLevel) {
        if (itemstack.func_77973_b().showDurabilityBar(itemstack)) {
            double health = itemstack.func_77973_b().getDurabilityForDisplay(itemstack);
            int j1 = (int)Math.round(13.0 - health * 13.0);
            int k = (int)Math.round(255.0 - health * 255.0);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.func_178181_a();
            int l = 255 - k << 16 | k << 8 | 0xFF000000;
            int i1 = (255 - k) / 4 << 16 | 0x3F00 | 0xFF000000;
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 15, 13, 2, Color.BLACK, zLevel);
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 15, 12, 1, i1, zLevel + 1.0);
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 15, j1, 1, l, zLevel + 2.0);
            GL11.glEnable((int)3553);
        }
    }

    public static void displayItemToolTip(Object[] tooltip, Gui gui, float pzLevel, int guiLeft, int guiTop) {
        GuiGraphics.displayItemToolTip(tooltip, pzLevel, guiLeft, guiTop, false);
    }

    public static void displayItemToolTip(Object[] tooltip, float pzLevel, int guiLeft, int guiTop, boolean forceAdd) {
        int y;
        int x;
        if (tooltip == null) {
            return;
        }
        zLevel = pzLevel;
        Minecraft mc = FMLClientHandler.instance().getClient();
        ItemStack stack = (ItemStack)tooltip[2];
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        List<String> tooltipLines = mc.field_71462_r instanceof GuiContainer ? SimpleServiceLocator.neiProxy.getItemToolTip(stack, (EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL), (GuiContainer)mc.field_71462_r) : stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        if (tooltip.length > 4) {
            tooltipLines.addAll(1, (List)tooltip[4]);
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (tooltip.length < 4 || ((Boolean)tooltip[3]).booleanValue())) {
            tooltipLines.add(1, "\u00a77" + ((ItemStack)tooltip[2]).func_190916_E());
        }
        if (!SimpleServiceLocator.neiProxy.renderItemToolTip(x = (Integer)tooltip[0] - (forceAdd ? 0 : guiLeft) + 12, y = (Integer)tooltip[1] - (forceAdd ? 0 : guiTop) - 12, tooltipLines, stack.func_77953_t().field_77937_e, stack)) {
            GuiGraphics.drawToolTip(x, y, tooltipLines, stack.func_77953_t().field_77937_e);
        }
        zLevel = 0.0f;
    }

    public static void drawToolTip(int posX, int posY, List<String> msg, TextFormatting rarityColor) {
        if (msg.isEmpty()) {
            return;
        }
        int boxWidth = 0;
        for (String str : msg) {
            int width = FMLClientHandler.instance().getClient().field_71466_p.func_78256_a(str);
            if (width <= boxWidth) continue;
            boxWidth = width;
        }
        int x = posX + 12;
        int y = posY - 12;
        int yHeight = 8;
        if (msg.size() > 1) {
            yHeight += 2 + (msg.size() - 1) * 10;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        zLevel = 300.0f;
        int bgColor = -267386864;
        int frameColor1 = 0x505000FF;
        int frameColor2 = (frameColor1 & 0xFEFEFE) >> 1 | frameColor1 & 0xFF000000;
        SimpleGraphics.drawGradientRect(x - 3, y - 4, x + boxWidth + 3, y - 3, bgColor, bgColor, 0.0);
        SimpleGraphics.drawGradientRect(x - 3, y + yHeight + 3, x + boxWidth + 3, y + yHeight + 4, bgColor, bgColor, 0.0);
        SimpleGraphics.drawGradientRect(x - 3, y - 3, x + boxWidth + 3, y + yHeight + 3, bgColor, bgColor, 0.0);
        SimpleGraphics.drawGradientRect(x - 4, y - 3, x - 3, y + yHeight + 3, bgColor, bgColor, 0.0);
        SimpleGraphics.drawGradientRect(x + boxWidth + 3, y - 3, x + boxWidth + 4, y + yHeight + 3, bgColor, bgColor, 0.0);
        SimpleGraphics.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + yHeight + 3 - 1, frameColor1, frameColor2, 0.0);
        SimpleGraphics.drawGradientRect(x + boxWidth + 2, y - 3 + 1, x + boxWidth + 3, y + yHeight + 3 - 1, frameColor1, frameColor2, 0.0);
        SimpleGraphics.drawGradientRect(x - 3, y - 3, x + boxWidth + 3, y - 3 + 1, frameColor1, frameColor1, 0.0);
        SimpleGraphics.drawGradientRect(x - 3, y + yHeight + 2, x + boxWidth + 3, y + yHeight + 3, frameColor2, frameColor2, 0.0);
        for (int i = 0; i < msg.size(); ++i) {
            String line = msg.get(i);
            line = i == 0 ? rarityColor.toString() + line : "\u00a77" + line;
            FMLClientHandler.instance().getClient().field_71466_p.func_175063_a(line, (float)x, (float)y, -1);
            if (i == 0) {
                y += 2;
            }
            y += 10;
        }
        zLevel = 0.0f;
        GlStateManager.func_179126_j();
    }

    public static void drawPlayerInventoryBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                GuiGraphics.drawSlotBackground(mc, xOffset + column * 18 - 1, yOffset + row * 18 - 1);
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset + 58 - 1);
        }
    }

    public static void drawPlayerHotbarBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 9; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset - 1);
        }
    }

    public static void drawPlayerArmorBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 4; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset - 1, yOffset - 1 - i1 * 18);
        }
    }

    private static void doDrawSlotBackground(Minecraft mc, int x, int y, ResourceLocation slotDiskTexture) {
        zLevel = 0.0f;
        mc.field_71446_o.func_110577_a(slotDiskTexture);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 18), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 18), (double)(y + 18), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 18), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawSlotDiskBackground(Minecraft mc, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiGraphics.doDrawSlotBackground(mc, x, y, SLOT_DISK_TEXTURE);
    }

    public static void drawSlotProgrammerBackground(Minecraft mc, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiGraphics.doDrawSlotBackground(mc, x, y, SLOT_PROGRAMMER_TEXTURE);
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiGraphics.doDrawSlotBackground(mc, x, y, SLOT_TEXTURE);
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y, int color) {
        GlStateManager.func_179131_c((float)Color.getRed(color), (float)Color.getGreen(color), (float)Color.getBlue(color), (float)Color.getAlpha(color));
        GuiGraphics.doDrawSlotBackground(mc, x, y, SLOT_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawBigSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(BIG_SLOT_TEXTURE);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 26), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 26), (double)(y + 26), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 26), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawSmallSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(SMALL_SLOT_TEXTURE);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 8), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 8), (double)(y + 8), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 8), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    public static void renderIconAt(Minecraft mc, int x, int y, float zLevel, TextureAtlasSprite icon) {
        if (icon == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(new ResourceLocation(icon.func_94215_i()));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 16), (double)GuiGraphics.zLevel).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_181675_d();
        buf.func_181662_b((double)(x + 16), (double)(y + 16), (double)GuiGraphics.zLevel).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_181675_d();
        buf.func_181662_b((double)(x + 16), (double)y, (double)GuiGraphics.zLevel).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)GuiGraphics.zLevel).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawLockBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(LOCK_ICON);
        GlStateManager.func_179147_l();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 15), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 14), (double)(y + 15), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 14), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179084_k();
    }

    private static void drawTexture16by16(Minecraft mc, int x, int y, ResourceLocation tex) {
        zLevel = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(tex);
        GlStateManager.func_179147_l();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + 16), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 16), (double)(y + 16), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 16), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawLinesBackground(Minecraft mc, int x, int y) {
        GuiGraphics.drawTexture16by16(mc, x, y, LINES_ICON);
    }

    public static void drawStatsBackground(Minecraft mc, int x, int y) {
        GuiGraphics.drawTexture16by16(mc, x, y, STATS_ICON);
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor) {
        GuiGraphics.drawGuiBackGround(mc, guiLeft, guiTop, right, bottom, zLevel, resetColor, true, true, true, true);
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor, boolean displayTop, boolean displayLeft, boolean displayBottom, boolean displayRight) {
        if (resetColor) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        mc.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (displayTop) {
            buf.func_181662_b((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.33, 0.33).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.66, 0.33).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)guiTop, (double)zLevel).func_187315_a(0.66, 0.0).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)guiTop, (double)zLevel).func_187315_a(0.33, 0.0).func_181675_d();
        }
        if (displayLeft) {
            buf.func_181662_b((double)guiLeft, (double)(bottom - 15), (double)zLevel).func_187315_a(0.0, 0.66).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.33, 0.66).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.33, 0.33).func_181675_d();
            buf.func_181662_b((double)guiLeft, (double)(guiTop + 15), (double)zLevel).func_187315_a(0.0, 0.33).func_181675_d();
        }
        if (displayBottom) {
            buf.func_181662_b((double)(guiLeft + 15), (double)bottom, (double)zLevel).func_187315_a(0.33, 1.0).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)bottom, (double)zLevel).func_187315_a(0.66, 1.0).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.66, 0.66).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.33, 0.66).func_181675_d();
        }
        if (displayRight) {
            buf.func_181662_b((double)(right - 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.66, 0.66).func_181675_d();
            buf.func_181662_b((double)right, (double)(bottom - 15), (double)zLevel).func_187315_a(1.0, 0.66).func_181675_d();
            buf.func_181662_b((double)right, (double)(guiTop + 15), (double)zLevel).func_187315_a(1.0, 0.33).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.66, 0.33).func_181675_d();
        }
        if (displayTop && displayLeft) {
            buf.func_181662_b((double)guiLeft, (double)(guiTop + 15), (double)zLevel).func_187315_a(0.0, 0.33).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.33, 0.33).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)guiTop, (double)zLevel).func_187315_a(0.33, 0.0).func_181675_d();
            buf.func_181662_b((double)guiLeft, (double)guiTop, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        }
        if (displayBottom && displayLeft) {
            buf.func_181662_b((double)guiLeft, (double)bottom, (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)bottom, (double)zLevel).func_187315_a(0.33, 1.0).func_181675_d();
            buf.func_181662_b((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.33, 0.66).func_181675_d();
            buf.func_181662_b((double)guiLeft, (double)(bottom - 15), (double)zLevel).func_187315_a(0.0, 0.66).func_181675_d();
        }
        if (displayBottom && displayRight) {
            buf.func_181662_b((double)(right - 15), (double)bottom, (double)zLevel).func_187315_a(0.66, 1.0).func_181675_d();
            buf.func_181662_b((double)right, (double)bottom, (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
            buf.func_181662_b((double)right, (double)(bottom - 15), (double)zLevel).func_187315_a(1.0, 0.66).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.66, 0.66).func_181675_d();
        }
        if (displayTop && displayRight) {
            buf.func_181662_b((double)(right - 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.66, 0.33).func_181675_d();
            buf.func_181662_b((double)right, (double)(guiTop + 15), (double)zLevel).func_187315_a(1.0, 0.33).func_181675_d();
            buf.func_181662_b((double)right, (double)guiTop, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b((double)(right - 15), (double)guiTop, (double)zLevel).func_187315_a(0.66, 0.0).func_181675_d();
        }
        buf.func_181662_b((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.33, 0.66).func_181675_d();
        buf.func_181662_b((double)(right - 15), (double)(bottom - 15), (double)zLevel).func_187315_a(0.66, 0.66).func_181675_d();
        buf.func_181662_b((double)(right - 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.66, 0.33).func_181675_d();
        buf.func_181662_b((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel).func_187315_a(0.33, 0.33).func_181675_d();
        tess.func_78381_a();
    }
}

