/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidIdentifierStack
implements Comparable<FluidIdentifierStack> {
    private Object ccType;
    private final FluidIdentifier _fluid;
    private int milliBuckets;

    public FluidIdentifierStack(FluidIdentifier fluid, int milliBuckets) {
        this._fluid = fluid;
        this.setAmount(milliBuckets);
    }

    public static FluidIdentifierStack getFromStack(FluidStack stack) {
        FluidIdentifier fluid = FluidIdentifier.get(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidIdentifierStack(fluid, stack.amount);
    }

    public static FluidIdentifierStack getFromStack(ItemIdentifierStack stack) {
        FluidIdentifier fluid = FluidIdentifier.get(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidIdentifierStack(fluid, stack.getStackSize());
    }

    public FluidIdentifier getFluid() {
        return this._fluid;
    }

    public int getAmount() {
        return this.milliBuckets;
    }

    public void setAmount(int milliBuckets) {
        this.milliBuckets = milliBuckets;
    }

    public void lowerAmount(int milliBuckets) {
        this.milliBuckets -= milliBuckets;
    }

    public void raiseAmount(int milliBuckets) {
        this.milliBuckets += milliBuckets;
    }

    public FluidStack makeFluidStack() {
        return this._fluid.makeFluidStack(this.milliBuckets);
    }

    @Override
    public int compareTo(FluidIdentifierStack o) {
        int c = this._fluid.compareTo(o._fluid);
        if (c == 0) {
            return Integer.compare(this.getAmount(), o.getAmount());
        }
        return c;
    }
}

