/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.List;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.LPFinalSerializable;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public interface IOrderInfoProvider
extends LPFinalSerializable {
    public boolean isFinished();

    public ItemIdentifierStack getAsDisplayItem();

    public ResourceType getType();

    public int getRouterId();

    public boolean isInProgress();

    public boolean isWatched();

    public void setWatched();

    public List<Float> getProgresses();

    public byte getMachineProgress();

    public ItemIdentifier getTargetType();

    public DoubleCoordinates getTargetPosition();

    @Override
    default public void write(LPDataOutput output) {
        output.writeItemIdentifierStack(this.getAsDisplayItem());
        output.writeInt(this.getRouterId());
        output.writeBoolean(this.isFinished());
        output.writeBoolean(this.isInProgress());
        output.writeEnum(this.getType());
        output.writeCollection(this.getProgresses(), LPDataOutput::writeFloat);
        output.writeByte(this.getMachineProgress());
        if (this.getTargetPosition() != null) {
            output.writeBoolean(true);
            output.writeSerializable(this.getTargetPosition());
            output.writeItemIdentifier(this.getTargetType());
        } else {
            output.writeBoolean(false);
        }
    }

    public static enum ResourceType {
        PROVIDER,
        CRAFTING,
        EXTRA;

    }
}

