/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.List;
import java.util.UUID;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouterQueuedTask;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.LPFinalSerializable;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public interface IRouter
extends LPFinalSerializable {
    public void destroy();

    public void update(boolean var1, CoreRoutedPipe var2);

    public boolean isRoutedExit(EnumFacing var1);

    public boolean isSubPoweredExit(EnumFacing var1);

    public int getDistanceToNextPowerPipe(EnumFacing var1);

    public boolean hasRoute(int var1, boolean var2, ItemIdentifier var3);

    public ExitRoute getExitFor(int var1, boolean var2, ItemIdentifier var3);

    public List<List<ExitRoute>> getRouteTable();

    public List<ExitRoute> getIRoutersByCost();

    public CoreRoutedPipe getPipe();

    public CoreRoutedPipe getCachedPipe();

    public boolean isInDim(int var1);

    public boolean isAt(int var1, int var2, int var3, int var4);

    public UUID getId();

    public LogisticsModule getLogisticsModule();

    public void clearPipeCache();

    public int getSimpleID();

    public DoubleCoordinates getLPPosition();

    public boolean isSideDisconnected(EnumFacing var1);

    public List<ExitRoute> getDistanceTo(IRouter var1);

    public void clearInterests();

    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> getPowerProvider();

    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> getSubSystemPowerProvider();

    public boolean isCacheInvalid();

    public void forceLsaUpdate();

    public List<ExitRoute> getRoutersOnSide(EnumFacing var1);

    public void queueTask(int var1, IRouterQueuedTask var2);

    @Override
    default public void write(LPDataOutput output) {
        output.writeSerializable(this.getLPPosition());
    }
}

