/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleSatellite;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SyncSatelliteNamePacket;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.SatellitePipe;

public class PipeFluidSatellite
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport,
IHeadUpDisplayRendererProvider,
IChestContentReceiver,
SatellitePipe {
    public static final Set<PipeFluidSatellite> AllSatellites = new HashSet<PipeFluidSatellite>();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final List<ItemIdentifierStack> itemList = new LinkedList<ItemIdentifierStack>();
    private final List<ItemIdentifierStack> oldList = new LinkedList<ItemIdentifierStack>();
    private final HUDSatellite HUD = new HUDSatellite(this);
    protected final Map<FluidIdentifier, Integer> _lostItems = new HashMap<FluidIdentifier, Integer>();
    private final ModuleSatellite moduleSatellite;
    private String satellitePipeName = "";

    public static void cleanup() {
        AllSatellites.clear();
    }

    public PipeFluidSatellite(Item item) {
        super(item);
        this.throttleTime = 40;
        this.moduleSatellite = new ModuleSatellite();
        this.moduleSatellite.registerHandler(this, this);
        this.moduleSatellite.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_SATELLITE;
    }

    @Override
    @Nullable
    public LogisticsModule getLogisticsModule() {
        return this.moduleSatellite;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.isNthTick(20) && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public void sendFailed(FluidIdentifier liquid, Integer amount) {
        this.liquidLost(liquid, amount);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        this.itemList.addAll(PipeFluidUtil.INSTANCE.fluidsToItemList(this));
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChestContent.class).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("satelliteid")) {
            int satelliteId = nbttagcompound.func_74762_e("satelliteid");
            this.satellitePipeName = Integer.toString(satelliteId);
        } else {
            this.satellitePipeName = nbttagcompound.func_74779_i("satellitePipeName");
        }
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.ensureAllSatelliteStatus();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("satellitePipeName", this.satellitePipeName);
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void ensureAllSatelliteStatus() {
        if (this.satellitePipeName.isEmpty()) {
            AllSatellites.remove(this);
        } else {
            AllSatellites.add(this);
        }
    }

    @Override
    public void updateWatchers() {
        LogisticsTileGenericPipe container = (LogisticsTileGenericPipe)Objects.requireNonNull(this.getContainer());
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setTilePos(container);
        MainProxy.sendToPlayerList((ModernPacket)packet, this.localModeWatchers);
        MainProxy.sendPacketToAllWatchingChunk(container, (ModernPacket)packet);
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        AllSatellites.remove(this);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer(packet, entityplayer);
        entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<FluidIdentifier, Integer>> iterator2 = this._lostItems.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<FluidIdentifier, Integer> stack = iterator2.next();
            int received = RequestTree.requestFluidPartial(stack.getKey(), stack.getValue(), this, null);
            if (received <= 0) continue;
            if (received == stack.getValue()) {
                iterator2.remove();
                continue;
            }
            stack.setValue(stack.getValue() - received);
        }
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        if (this._lostItems.containsKey(item)) {
            this._lostItems.put(item, this._lostItems.get(item) + amount);
        } else {
            this._lostItems.put(item, amount);
        }
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
        this.liquidLost(item, amount);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }

    @Override
    @Nonnull
    public Set<SatellitePipe> getSatellitesOfType() {
        return Collections.unmodifiableSet(AllSatellites);
    }

    @Override
    public void setSatellitePipeName(@Nonnull String satellitePipeName) {
        this.satellitePipeName = satellitePipeName;
    }

    @Override
    @Nonnull
    public List<ItemIdentifierStack> getItemList() {
        return this.itemList;
    }

    @Override
    public String getSatellitePipeName() {
        return this.satellitePipeName;
    }
}

