/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipeManagerWatchingPacket
extends CoordinatesPacket {
    private boolean start;

    public PipeManagerWatchingPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe.pipe;
        if (this.start) {
            cPipe.getOrderManager().startWatching(player);
        } else {
            cPipe.getOrderManager().stopWatching(player);
        }
    }

    @Override
    public ModernPacket template() {
        return new PipeManagerWatchingPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.start);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.start = input.readBoolean();
    }

    public boolean isStart() {
        return this.start;
    }

    public PipeManagerWatchingPacket setStart(boolean start) {
        this.start = start;
        return this;
    }
}

