/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PowerPacketLaser
extends CoordinatesPacket {
    private EnumFacing dir;
    private int color;
    private boolean reverse;
    private boolean renderBall;
    private float length;
    private boolean remove = false;

    public PowerPacketLaser(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.length = input.readFloat();
        this.dir = input.readFacing();
        this.color = input.readInt();
        this.reverse = input.readBoolean();
        this.renderBall = input.readBoolean();
        this.remove = input.readBoolean();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_());
        if (this.remove) {
            tile.removeLaser(this.dir, this.getColor(), this.isRenderBall());
        } else {
            tile.addLaser(this.dir, this.getLength(), this.getColor(), this.isReverse(), this.isRenderBall());
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeFloat(this.length);
        output.writeFacing(this.dir);
        output.writeInt(this.color);
        output.writeBoolean(this.reverse);
        output.writeBoolean(this.renderBall);
        output.writeBoolean(this.remove);
    }

    @Override
    public ModernPacket template() {
        return new PowerPacketLaser(this.getId());
    }

    public EnumFacing getDir() {
        return this.dir;
    }

    public PowerPacketLaser setDir(EnumFacing dir) {
        this.dir = dir;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public PowerPacketLaser setColor(int color) {
        this.color = color;
        return this;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public PowerPacketLaser setReverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public boolean isRenderBall() {
        return this.renderBall;
    }

    public PowerPacketLaser setRenderBall(boolean renderBall) {
        this.renderBall = renderBall;
        return this;
    }

    public float getLength() {
        return this.length;
    }

    public PowerPacketLaser setLength(float length) {
        this.length = length;
        return this;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public PowerPacketLaser setRemove(boolean remove) {
        this.remove = remove;
        return this;
    }
}

