/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import javax.annotation.Nonnull;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CompilerStatusPacket
extends CoordinatesPacket {
    private ResourceLocation category;
    private double progress;
    private boolean wasAbleToConsumePower;
    @Nonnull
    private ItemStack disk;
    @Nonnull
    private ItemStack programmer;

    public CompilerStatusPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsProgramCompilerTileEntity tile = this.getTileAs(player.field_70170_p, LogisticsProgramCompilerTileEntity.class);
        tile.setStateOnClient(this);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeResourceLocation(this.category);
        output.writeDouble(this.progress);
        output.writeBoolean(this.wasAbleToConsumePower);
        output.writeItemStack(this.disk);
        output.writeItemStack(this.programmer);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.category = input.readResourceLocation();
        this.progress = input.readDouble();
        this.wasAbleToConsumePower = input.readBoolean();
        this.disk = input.readItemStack();
        this.programmer = input.readItemStack();
    }

    @Override
    public ModernPacket template() {
        return new CompilerStatusPacket(this.getId());
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    public CompilerStatusPacket setCategory(ResourceLocation category) {
        this.category = category;
        return this;
    }

    public double getProgress() {
        return this.progress;
    }

    public CompilerStatusPacket setProgress(double progress) {
        this.progress = progress;
        return this;
    }

    public boolean isWasAbleToConsumePower() {
        return this.wasAbleToConsumePower;
    }

    public CompilerStatusPacket setWasAbleToConsumePower(boolean wasAbleToConsumePower) {
        this.wasAbleToConsumePower = wasAbleToConsumePower;
        return this;
    }

    @Nonnull
    public ItemStack getDisk() {
        return this.disk;
    }

    public CompilerStatusPacket setDisk(@Nonnull ItemStack disk) {
        if (disk == null) {
            throw new NullPointerException("disk is marked non-null but is null");
        }
        this.disk = disk;
        return this;
    }

    @Nonnull
    public ItemStack getProgrammer() {
        return this.programmer;
    }

    public CompilerStatusPacket setProgrammer(@Nonnull ItemStack programmer) {
        if (programmer == null) {
            throw new NullPointerException("programmer is marked non-null but is null");
        }
        this.programmer = programmer;
        return this;
    }
}

