/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.util.function.Function;
import javax.annotation.Nonnull;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class CoordinatesPacket
extends ModernPacket {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesPacket(int id) {
        super(id);
    }

    @Nonnull
    public static <T> T getTileAs(Object whosAsking, World world, BlockPos blockPos, Class<T> clazz) {
        TileEntity tile = CoordinatesPacket.getWorldTile(whosAsking, world, blockPos);
        if (tile != null) {
            if (clazz.isAssignableFrom(tile.getClass())) {
                return (T)tile;
            }
            throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", found " + tile.getClass() + " at: " + blockPos, whosAsking);
        }
        throw new TargetNotFoundException("Couldn't find " + clazz.getName() + " at: " + blockPos, whosAsking);
    }

    private static TileEntity getWorldTile(Object whosAsking, World world, BlockPos blockPos) {
        if (world == null) {
            throw new TargetNotFoundException("World was null", whosAsking);
        }
        if (world.func_175623_d(blockPos)) {
            throw new TargetNotFoundException("Only found air at: " + blockPos, whosAsking);
        }
        return world.func_175625_s(blockPos);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.posX);
        output.writeInt(this.posY);
        output.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.posX = input.readInt();
        this.posY = input.readInt();
        this.posZ = input.readInt();
    }

    public CoordinatesPacket setTilePos(TileEntity tile) {
        this.setDimension(tile.func_145831_w());
        this.setPosX(tile.func_174877_v().func_177958_n());
        this.setPosY(tile.func_174877_v().func_177956_o());
        this.setPosZ(tile.func_174877_v().func_177952_p());
        return this;
    }

    public CoordinatesPacket setLPPos(DoubleCoordinates pos) {
        this.setPosX(pos.getXInt());
        this.setPosY(pos.getYInt());
        this.setPosZ(pos.getZInt());
        return this;
    }

    public CoordinatesPacket setPacketPos(CoordinatesPacket packet) {
        this.posX = packet.posX;
        this.posY = packet.posY;
        this.posZ = packet.posZ;
        return this;
    }

    public CoordinatesPacket setBlockPos(BlockPos pos) {
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        return this;
    }

    public TileEntity getTileAs(World world, Function<TileEntity, Boolean> validateResult) {
        TileEntity tile = this.getTileAs(world, TileEntity.class);
        if (!validateResult.apply(tile).booleanValue()) {
            throw new TargetNotFoundException("TileEntity condition not met", this);
        }
        return tile;
    }

    public <T> T getTileAs(World world, Class<T> clazz) {
        return CoordinatesPacket.getTileAs(this, world, new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()), clazz);
    }

    public <T> T getTileOrPipe(World world, Class<T> clazz) {
        TileEntity tile = CoordinatesPacket.getWorldTile(this, world, new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        if (tile != null) {
            if (clazz.isAssignableFrom(tile.getClass())) {
                return (T)tile;
            }
            if (tile instanceof LogisticsTileGenericPipe) {
                if (((LogisticsTileGenericPipe)tile).pipe != null && clazz.isAssignableFrom(((LogisticsTileGenericPipe)tile).pipe.getClass())) {
                    return (T)((LogisticsTileGenericPipe)tile).pipe;
                }
                throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", found pipe with " + tile.getClass() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()), this);
            }
        } else {
            throw new TargetNotFoundException("Couldn't find " + clazz.getName() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()), this);
        }
        throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", found " + tile.getClass() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()), this);
    }

    @Deprecated
    public LogisticsTileGenericPipe getPipe(World world) {
        return this.getPipe(world, LTGPCompletionCheck.NONE);
    }

    @Nonnull
    public LogisticsTileGenericPipe getPipe(World world, LTGPCompletionCheck check) {
        LogisticsTileGenericPipe pipe = this.getTileAs(world, LogisticsTileGenericPipe.class);
        if ((check == LTGPCompletionCheck.PIPE || check == LTGPCompletionCheck.TRANSPORT) && pipe.pipe == null) {
            throw new TargetNotFoundException("The found pipe didn't have a loaded pipe field", this);
        }
        if (check == LTGPCompletionCheck.TRANSPORT && pipe.pipe.transport == null) {
            throw new TargetNotFoundException("The found pipe didn't have a loaded transport field", this);
        }
        return pipe;
    }

    public String toString() {
        return "CoordinatesPacket(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesPacket setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesPacket setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesPacket setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }

    public static enum LTGPCompletionCheck {
        NONE,
        PIPE,
        TRANSPORT;

    }
}

