/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.module.PipeServiceProviderUtilKt;
import network.rs485.logisticspipes.property.Property;

public class ModulePolymorphicItemSink
extends LogisticsModule {
    private SinkReply _sinkReply;

    public static String getName() {
        return "item_sink_polymorphic";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModulePolymorphicItemSink.getName();
    }

    @Override
    @NotNull
    public List<Property<?>> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 3, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        ISlotUpgradeManager upgradeManager = service.getUpgradeManager(this.slot, this.positionInt);
        IInventoryUtil targetInventory = PipeServiceProviderUtilKt.availableSneakyInventories(service, upgradeManager).stream().findFirst().orElse(null);
        if (targetInventory == null) {
            return null;
        }
        if (!targetInventory.containsUndamagedItem(item.getUndamaged())) {
            return null;
        }
        if (service.canUseEnergy(3)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return true;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean receivePassive() {
        return true;
    }
}

