/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.util.EnumFacing;

public class ChassisTransportLayer
extends TransportLayer {
    private final PipeLogisticsChassis _chassisPipe;

    public ChassisTransportLayer(PipeLogisticsChassis chassisPipe) {
        this._chassisPipe = chassisPipe;
    }

    @Override
    public EnumFacing itemArrived(IRoutedItem item, EnumFacing denied) {
        if (item.getItemIdentifierStack() != null) {
            this._chassisPipe.receivedItem(item.getItemIdentifierStack().getStackSize());
        }
        return this._chassisPipe.getPointedOrientation();
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        LogisticsModule module = this._chassisPipe.getLogisticsModule();
        if (module == null) {
            this._chassisPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (!this._chassisPipe.isEnabled()) {
            this._chassisPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        ItemIdentifierStack itemIdStack = item.getItemIdentifierStack();
        SinkReply reply = module.sinksItem(itemIdStack.makeNormalStack(), itemIdStack.getItem(), -1, 0, true, false, false);
        if (reply == null || reply.maxNumberOfItems < 0) {
            this._chassisPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (reply.maxNumberOfItems > 0 && itemIdStack.getStackSize() > reply.maxNumberOfItems) {
            EnumFacing o = this._chassisPipe.getPointedOrientation();
            if (o == null) {
                o = EnumFacing.UP;
            }
            item.split(reply.maxNumberOfItems, o);
        }
        return true;
    }
}

