/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.commands;

import java.lang.reflect.Method;
import logisticspipes.commands.abstracts.ICommandHandler;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlinx.coroutines.Job;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TestCommand
implements ICommandHandler {
    @Override
    public String[] getNames() {
        return new String[]{"retest"};
    }

    @Override
    public boolean isCommandUsableBy(ICommandSender sender) {
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Reruns all tests"};
    }

    @Override
    public void executeCommand(ICommandSender sender, String[] args2) {
        Class<?> testClass;
        try {
            testClass = Class.forName("network.rs485.logisticspipes.integration.MinecraftTest");
        }
        catch (ReflectiveOperationException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Error loading minecraft test class " + e));
            return;
        }
        try {
            Object minecraftTestInstance = testClass.getDeclaredField("INSTANCE").get(null);
            Method startTestsMethod = testClass.getDeclaredMethod("startTests", Function1.class);
            Job job = (Job)startTestsMethod.invoke(minecraftTestInstance, msg -> {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(msg)));
                return Unit.INSTANCE;
            });
            job.invokeOnCompletion(throwable -> {
                if (throwable == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "SUCCESS"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Tests failed with: " + throwable));
                }
                return Unit.INSTANCE;
            });
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Error accessing minecraft test instance " + e));
        }
    }
}

