/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.ic2patcher.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IC2VersionExtractor {
    private static String ic2Version = null;
    private static final Logger logger = LogManager.getLogger((String)"IC2-Patcher/IC2VersionExtraction");

    public static String getIc2Version() throws IOException {
        return IC2VersionExtractor.getIC2Version(null);
    }

    public static String getIC2Version(File mcLocation) throws IOException {
        if (mcLocation == null || ic2Version != null) {
            return ic2Version;
        }
        File mods = new File(mcLocation, "mods");
        if (!mods.exists() || mods.listFiles() == null) {
            logger.fatal("No mods folder exists or list of files returned is null! This error will cause a crash.");
            return null;
        }
        Function<File, String> searcher = modsDir -> {
            File[] fileArray = modsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && !file.isDirectory() && file.getName().endsWith(".jar")) {
                    try (ZipFile zip = new ZipFile(file);){
                        Map mcModInfo;
                        ZipEntry mcModInfoEntry = zip.getEntry("mcmod.info");
                        if (mcModInfoEntry != null && Objects.equals((mcModInfo = (Map)((List)new Gson().fromJson((Reader)new InputStreamReader(zip.getInputStream(mcModInfoEntry)), Object.class)).get(0)).get("modid"), "ic2")) {
                            ic2Version = (String)mcModInfo.get("version");
                            logger.info("IC2 was found! Extracted version: " + ic2Version);
                            String string = ic2Version;
                            return string;
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return null;
        };
        String ver = searcher.apply(mods);
        if (ver != null) {
            return ver;
        }
        if ((mods = new File(mods, "1.12.2")).exists() && mods.isDirectory() && (ver = searcher.apply(mods)) != null) {
            return ver;
        }
        logger.fatal("No IC2 was found in the mods folder. Is IC2 Installed? This error will cause a crash.");
        return null;
    }
}

