/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei.init;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import java.util.ArrayList;
import net.bdew.gendustry.config.Tuning;
import net.bdew.gendustry.items.GeneTemplate;
import net.bdew.gendustry.misc.GendustryCreativeTabs;
import net.bdew.lib.recipes.RecipeStatement;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import ninjabrain.gendustryjei.init.RecipeConverter;
import ninjabrain.gendustryjei.wrappers.WrapperReplicator;

public class RecipeConverterReplicator
extends RecipeConverter<WrapperReplicator> {
    /*
     * WARNING - void declaration
     */
    public RecipeConverterReplicator(ArrayList<WrapperReplicator> wrapperList) {
        super(wrapperList);
        NonNullList templates = NonNullList.func_191196_a();
        GeneTemplate.getSubItems((CreativeTabs)GendustryCreativeTabs.templates(), (NonNullList)templates);
        boolean makePristineBees = Tuning.getSection((String)"Machines").getSection("Replicator").getBoolean("MakePristineBees");
        for (ItemStack template : templates) {
            void var12_12;
            EnumBeeType type;
            NBTTagCompound compound;
            ISpeciesRoot root = GeneTemplate.getSpecies((ItemStack)template);
            if (root == null || (compound = template.func_77978_p()) == null) continue;
            NBTTagCompound chromosome0 = (NBTTagCompound)compound.func_150295_c("samples", 10).func_179238_g(0);
            String species = chromosome0.func_74779_i("allele");
            IAllele[] genome = (IAllele[])root.getGenomeTemplates().get(species);
            IIndividual individual = root.templateAsIndividual(genome);
            if (root == BeeManager.beeRoot) {
                type = EnumBeeType.QUEEN;
                IBee bee = (IBee)individual;
                bee.setIsNatural(makePristineBees);
            } else if (root == TreeManager.treeRoot) {
                type = EnumGermlingType.SAPLING;
            } else {
                if (root != ButterflyManager.butterflyRoot) continue;
                type = EnumFlutterType.BUTTERFLY;
            }
            ItemStack outputStack = root.getMemberStack(individual, (ISpeciesType)var12_12);
            wrapperList.add(new WrapperReplicator(template, outputStack));
        }
    }

    @Override
    public void processRecipeStatement(RecipeStatement rs) {
    }
}

