/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei.init;

import forestry.api.apiculture.BeeManager;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.List;
import net.bdew.gendustry.config.Tuning;
import net.bdew.lib.recipes.RecipeStatement;
import net.bdew.lib.recipes.gencfg.ConfigSection;
import ninjabrain.gendustryjei.init.RecipeConverter;
import ninjabrain.gendustryjei.wrappers.WrapperMutatron;

public class RecipeConverterMutatron
extends RecipeConverter<WrapperMutatron> {
    public RecipeConverterMutatron(ArrayList<WrapperMutatron> wrapperList) {
        super(wrapperList);
        ISpeciesRoot[] roots;
        ConfigSection bannedMutations = Tuning.getSection((String)"Genetics").getSection("MutatronOverrides");
        for (ISpeciesRoot root : roots = new ISpeciesRoot[]{BeeManager.beeRoot, TreeManager.treeRoot}) {
            List mutations = root.getMutations(false);
            for (IMutation mutation : mutations) {
                if (mutation.getTemplate() == null || mutation.getTemplate().length == 0) continue;
                IAllele resultSpecies = mutation.getTemplate()[0];
                String uidResultSpecies = resultSpecies.getUID();
                boolean include = true;
                if (bannedMutations.hasValue(uidResultSpecies)) {
                    String value = bannedMutations.getString(uidResultSpecies);
                    if (value.equalsIgnoreCase("DISABLED")) {
                        include = false;
                    } else if (value.equalsIgnoreCase("REQUIREMENTS")) {
                        include = false;
                    }
                }
                if (!include) continue;
                wrapperList.add(new WrapperMutatron(mutation));
            }
        }
    }

    @Override
    public void processRecipeStatement(RecipeStatement rs) {
    }
}

