/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TileMovingBase;
import com.rwtema.funkylocomotion.movers.MoverEventHandler;
import com.rwtema.funkylocomotion.movers.MovingTileRegistry;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;

public class TileMovingServer
extends TileMovingBase {
    public WeakReference<EntityPlayer> activatingPlayer = null;
    public EnumFacing activatingSide = null;
    public EnumHand activatingHand = null;
    public float activatingHitX;
    public float activatingHitY;
    public float activatingHitZ;

    public TileMovingServer() {
        super(Side.SERVER);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        if (this.desc == null) {
            return super.func_189517_E_();
        }
        this.desc.func_74768_a("Time", this.time);
        this.desc.func_74768_a("MaxTime", this.maxTime);
        this.desc.func_74774_a("Dir", (byte)this.dir);
        if (this.block != null) {
            this.desc.func_74782_a("BlockTag", (NBTBase)this.block);
        }
        if (this.collisions.length > 0) {
            this.desc.func_74782_a("Collisions", (NBTBase)TileMovingServer.TagsAxis(this.collisions));
        }
        if (this.lightLevel != 0) {
            this.desc.func_74774_a("Light", (byte)this.lightLevel);
        }
        if (this.lightOpacity != 0) {
            this.desc.func_74777_a("Opacity", (short)this.lightOpacity);
        }
        return this.desc;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        MovingTileRegistry.deregister(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        MovingTileRegistry.deregister(this);
    }

    public void func_145829_t() {
        super.func_145829_t();
        MovingTileRegistry.register(this);
    }

    @Override
    public void func_73660_a() {
        if (this.time < this.maxTime) {
            super.func_73660_a();
            this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
        } else {
            MoverEventHandler.registerFinisher();
        }
    }

    public void cacheActivate(EntityPlayer player, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ) {
        if (this.activatingPlayer == null || this.activatingPlayer.get() == null) {
            this.activatingPlayer = new WeakReference<EntityPlayer>(player);
            this.activatingSide = side;
            this.activatingHand = hand;
            this.activatingHitX = hitX;
            this.activatingHitY = hitY;
            this.activatingHitZ = hitZ;
        }
    }
}

