/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.LepidopterologyFilterRule;
import forestry.lepidopterology.LepidopterologyFilterRuleType;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyFactory;
import forestry.lepidopterology.genetics.ButterflyMutationFactory;
import forestry.lepidopterology.genetics.ButterflyRoot;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.items.ItemRegistryLepidopterology;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.recipes.MatingRecipe;
import forestry.lepidopterology.render.ModelButterflyItem;
import forestry.lepidopterology.tiles.TileCocoon;
import forestry.lepidopterology.worldgen.CocoonDecorator;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ForestryModule(containerID="forestry", moduleID="lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.lepidopterology.description")
public class ModuleLepidopterology
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.lepidopterology.proxy.ProxyLepidopterologyClient", serverSide="forestry.lepidopterology.proxy.ProxyLepidopterology")
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    public static int spawnConstraint;
    public static int entityConstraint;
    public static int maxDistance;
    public static int maxLifespan;
    private static boolean allowPollination;
    public static final Map<String, Float> spawnRaritys;
    private static boolean spawnButterflysFromLeaves;
    private static boolean generateCocoons;
    private static float generateCocoonsAmount;
    private static float serumChance;
    private static float secondSerumChance;
    @Nullable
    private static ItemRegistryLepidopterology items;
    @Nullable
    private static BlockRegistryLepidopterology blocks;

    public static ItemRegistryLepidopterology getItems() {
        Preconditions.checkNotNull((Object)items);
        return items;
    }

    public static BlockRegistryLepidopterology getBlocks() {
        Preconditions.checkNotNull((Object)blocks);
        return blocks;
    }

    @Override
    public void setupAPI() {
        ButterflyManager.butterflyRoot = new ButterflyRoot();
        AlleleManager.alleleRegistry.registerSpeciesRoot(ButterflyManager.butterflyRoot);
        ButterflyManager.butterflyFactory = new ButterflyFactory();
        ButterflyManager.butterflyMutationFactory = new ButterflyMutationFactory();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryLepidopterology();
        blocks = new BlockRegistryLepidopterology();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ButterflyBranchDefinition.createAlleles();
        ButterflyAlleles.registerEffectAlleles();
        ButterflyDefinition.preInit();
        MothDefinition.preInit();
        MinecraftForge.EVENT_BUS.post(new AlleleSpeciesRegisterEvent<IAlleleButterflySpecies>(ButterflyManager.butterflyRoot, IAlleleButterflySpecies.class));
        proxy.preInitializeRendering();
        if (ModuleHelper.isEnabled("sorting")) {
            LepidopterologyFilterRule.init();
            LepidopterologyFilterRuleType.init();
        }
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        HashSet<ResourceLocation> dependencyUids = new HashSet<ResourceLocation>();
        dependencyUids.add(new ResourceLocation("forestry", "core"));
        dependencyUids.add(new ResourceLocation("forestry", "arboriculture"));
        return dependencyUids;
    }

    @Override
    public void doInit() {
        BlockRegistryLepidopterology blocks = ModuleLepidopterology.getBlocks();
        TileUtil.registerTile(TileCocoon.class, "cocoon");
        ModuleCore.rootCommand.addChildCommand(new CommandButterfly());
        ResourceLocation butterflyResourceLocation = new ResourceLocation("forestry", "butterflyGE");
        EntityUtil.registerEntity(butterflyResourceLocation, EntityButterfly.class, "butterflyGE", 0, 0, 0xFFFFFF, 50, 1, true);
        MothDefinition.initMoths();
        ButterflyDefinition.initButterflies();
        ButterflyAlleles.createLoot();
        MinecraftForge.EVENT_BUS.post(new AlleleSpeciesRegisterEvent<IAlleleButterflySpecies>(ButterflyManager.butterflyRoot, IAlleleButterflySpecies.class));
        blocks.butterflyChest.init();
        if (spawnButterflysFromLeaves) {
            TreeManager.treeRoot.registerLeafTickHandler(new ButterflySpawner());
        }
        RecipeSorter.register((String)"forestry:lepidopterologymating", MatingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
    }

    @Override
    public void postInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.cfg");
        ModuleLepidopterology.loadConfig(configFile);
    }

    @Override
    public void populateChunk(IChunkGenerator chunkGenerator, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (generateCocoons && (double)generateCocoonsAmount > 0.0) {
            CocoonDecorator.decorateCocoons(chunkGenerator, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (generateCocoons && (double)generateCocoonsAmount > 0.0) {
            CocoonDecorator.decorateCocoons(world, rand, chunkX, chunkZ);
        }
    }

    private static void loadConfig(File configFile) {
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.2.0");
        spawnConstraint = config.getIntLocalized("butterfly.entities", "spawn.limit", spawnConstraint, 0, 500);
        entityConstraint = config.getIntLocalized("butterfly.entities", "maximum", entityConstraint, 0, 5000);
        maxDistance = config.getIntLocalized("butterfly.entities", "maxDistance", maxDistance, 0, 256);
        maxLifespan = config.getIntLocalized("butterfly.entities", "maxLifespan", maxLifespan, 0, Integer.MAX_VALUE);
        allowPollination = config.getBooleanLocalized("butterfly.entities", "pollination", allowPollination);
        spawnButterflysFromLeaves = config.getBooleanLocalized("butterfly.entities", "spawn.leaves", spawnButterflysFromLeaves);
        generateCocoons = config.getBooleanLocalized("butterfly.cocoons", "generate", generateCocoons);
        generateCocoonsAmount = config.getFloatLocalized("butterfly.cocoons", "generate.amount", generateCocoonsAmount, 0.0f, 10.0f);
        serumChance = config.getFloatLocalized("butterfly.cocoons", "serum", serumChance, 0.0f, 100.0f);
        secondSerumChance = config.getFloatLocalized("butterfly.cocoons", "second.serum", secondSerumChance, 0.0f, 100.0f);
        ModuleLepidopterology.parseRarity(config);
        ModuleLepidopterology.parseCooconLoots(config);
        config.save();
    }

    private static void parseRarity(LocalizedConfiguration config) {
        String[] configRaritys;
        ArrayList butterflyRarity = Lists.newArrayList();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleButterflySpecies)) continue;
            IAlleleButterflySpecies species = (IAlleleButterflySpecies)allele;
            butterflyRarity.add(species.getUID() + ":" + species.getRarity());
        }
        Collections.sort(butterflyRarity);
        String[] defaultRaritys = butterflyRarity.toArray(new String[butterflyRarity.size()]);
        Property rarityConf = config.get("butterfly.alleles", "rarity", defaultRaritys);
        rarityConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.rarity"));
        for (String rarity : configRaritys = rarityConf.getStringList()) {
            if (!rarity.contains(":") || rarity.length() <= 3) continue;
            String[] raritys = rarity.split(":");
            try {
                spawnRaritys.put(raritys[0], Float.valueOf(Float.parseFloat(raritys[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse spawn rarity for butterfly. {}", rarity, e);
            }
        }
    }

    private static void parseCooconLoots(LocalizedConfiguration config) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleButterflyCocoon)) continue;
            ModuleLepidopterology.parseCooconLoot(config, (IAlleleButterflyCocoon)allele);
        }
    }

    private static void parseCooconLoot(LocalizedConfiguration config, IAlleleButterflyCocoon cocoon) {
        HashMap<ItemStack, Float> cooconLoot = new HashMap<ItemStack, Float>();
        ArrayList<String> lootList = new ArrayList<String>();
        for (Map.Entry<ItemStack, Float> entry : cocoon.getCocoonLoot().entrySet()) {
            String itemStackString = ItemStackUtil.getItemNameFromRegistryAsString(entry.getKey().func_77973_b());
            int meta = entry.getKey().func_77952_i();
            if (meta != Short.MAX_VALUE) {
                itemStackString = itemStackString + ':' + meta;
            }
            lootList.add(itemStackString + ";" + entry.getValue());
        }
        Collections.sort(lootList);
        String[] defaultLoot = lootList.toArray(new String[0]);
        Property lootConf = config.get("butterfly.cocoons.alleles.loot", cocoon.getUID(), defaultLoot);
        lootConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.loot"));
        String[] configLoot = lootConf.getStringList();
        for (String loot : configLoot) {
            if (!loot.contains(";") || loot.length() <= 3) continue;
            String[] loots = loot.split(";");
            try {
                ItemStack itemStack = ItemStackUtil.parseItemStackString(loots[0], Short.MAX_VALUE);
                if (itemStack == null) continue;
                cooconLoot.put(itemStack, Float.valueOf(Float.parseFloat(loots[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse cocoon loot. {}", loot, e);
            }
        }
        cocoon.clearLoot();
        for (Map.Entry entry : cooconLoot.entrySet()) {
            cocoon.addLoot((ItemStack)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
    }

    @Override
    public void registerRecipes() {
        BlockRegistryLepidopterology blocks = ModuleLepidopterology.getBlocks();
        ItemRegistryLepidopterology items = ModuleLepidopterology.getItems();
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MatingRecipe());
        RecipeUtil.addRecipe("butterfly_chest", blocks.butterflyChest, " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), new ItemStack((Item)items.butterflyGE, 1, Short.MAX_VALUE), Character.valueOf('Y'), "chestWood");
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        BlockRegistryLepidopterology blocks = ModuleLepidopterology.getBlocks();
        hiddenItems.add(new ItemStack((Block)blocks.cocoon));
        hiddenItems.add(new ItemStack((Block)blocks.solidCocoon));
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    public static boolean isSpawnButterflysFromLeaves() {
        return spawnButterflysFromLeaves;
    }

    public static boolean isGenerateCocoons() {
        return generateCocoons;
    }

    public static float getGenerateCocoonsAmount() {
        return generateCocoonsAmount;
    }

    public static float getSerumChance() {
        return serumChance;
    }

    public static float getSecondSerumChance() {
        return secondSerumChance;
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof EntityButterfly) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        ModelButterflyItem.onModelBake(event);
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        maxDistance = 64;
        maxLifespan = 168000;
        allowPollination = true;
        spawnRaritys = Maps.newHashMap();
        spawnButterflysFromLeaves = true;
        generateCocoons = false;
        generateCocoonsAmount = 1.0f;
        serumChance = 0.55f;
        secondSerumChance = 0.0f;
    }
}

