/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.render;

import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileEngine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RenderEngine
extends TileEntitySpecialRenderer<TileEngine> {
    private final ModelRenderer boiler;
    private final ModelRenderer trunk;
    private final ModelRenderer piston;
    private final ModelRenderer extension;
    private final ResourceLocation[] textures;
    private static final float[] angleMap = new float[6];

    public RenderEngine(String baseTexture) {
        EngineModelBase model = new EngineModelBase();
        this.boiler = new ModelRenderer((ModelBase)model, 0, 0);
        this.boiler.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 6, 16);
        this.boiler.field_78800_c = 8.0f;
        this.boiler.field_78797_d = 8.0f;
        this.boiler.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer((ModelBase)model, 0, 0);
        this.trunk.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.piston = new ModelRenderer((ModelBase)model, 0, 0);
        this.piston.func_78789_a(-6.0f, -2.0f, -6.0f, 12, 4, 12);
        this.piston.field_78800_c = 8.0f;
        this.piston.field_78797_d = 8.0f;
        this.piston.field_78798_e = 8.0f;
        this.extension = new ModelRenderer((ModelBase)model, 0, 0);
        this.extension.func_78789_a(-5.0f, -3.0f, -5.0f, 10, 2, 10);
        this.extension.field_78800_c = 8.0f;
        this.extension.field_78797_d = 8.0f;
        this.extension.field_78798_e = 8.0f;
        this.textures = new ResourceLocation[]{new ForestryResource(baseTexture + "base.png"), new ForestryResource(baseTexture + "piston.png"), new ForestryResource(baseTexture + "extension.png"), new ForestryResource("textures/blocks/engine_trunk_highest.png"), new ForestryResource("textures/blocks/engine_trunk_higher.png"), new ForestryResource("textures/blocks/engine_trunk_high.png"), new ForestryResource("textures/blocks/engine_trunk_medium.png"), new ForestryResource("textures/blocks/engine_trunk_low.png")};
    }

    public void render(TileEngine engine, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState blockState;
        World worldObj;
        if (engine != null && (worldObj = engine.getWorldObj()).func_175667_e(engine.func_174877_v()) && (blockState = worldObj.func_180495_p(engine.func_174877_v())).func_177230_c() instanceof BlockBase) {
            EnumFacing facing = (EnumFacing)blockState.func_177229_b(BlockBase.FACING);
            this.render(engine.getTemperatureState(), engine.progress, engine.stagePiston, engine.pistonSpeedServer, partialTicks, facing, x, y, z);
            return;
        }
        this.render(TemperatureState.COOL, 0.25f, 0, 0.0f, 0.0f, EnumFacing.UP, x, y, z);
    }

    private void render(TemperatureState state, float progress, int stagePiston, float serverSpeed, float partialTicks, EnumFacing orientation, double x, double y, double z) {
        ResourceLocation texture;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        if (stagePiston != 0) {
            float smoothing = serverSpeed * partialTicks;
            progress += smoothing;
        }
        float step = progress > 0.5f ? 6.0f - (progress - 0.5f) * 12.0f : progress * 12.0f;
        float tfactor = step / 16.0f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.func_82601_c(), orientation.func_96559_d(), orientation.func_82599_e()};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            default: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.boiler.field_78795_f = angle[0];
        this.boiler.field_78796_g = angle[1];
        this.boiler.field_78808_h = angle[2];
        this.trunk.field_78795_f = angle[0];
        this.trunk.field_78796_g = angle[1];
        this.trunk.field_78808_h = angle[2];
        this.piston.field_78795_f = angle[0];
        this.piston.field_78796_g = angle[1];
        this.piston.field_78808_h = angle[2];
        this.extension.field_78795_f = angle[0];
        this.extension.field_78796_g = angle[1];
        this.extension.field_78808_h = angle[2];
        float factor = 0.0625f;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.textures[Textures.BASE.ordinal()]);
        this.boiler.func_78785_a(factor);
        textureManager.func_110577_a(this.textures[Textures.PISTON.ordinal()]);
        GlStateManager.func_179109_b((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.piston.func_78785_a(factor);
        GlStateManager.func_179109_b((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        switch (state) {
            case OVERHEATING: {
                texture = this.textures[Textures.TRUNK_HIGHEST.ordinal()];
                break;
            }
            case RUNNING_HOT: {
                texture = this.textures[Textures.TRUNK_HIGHER.ordinal()];
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = this.textures[Textures.TRUNK_HIGH.ordinal()];
                break;
            }
            case WARMED_UP: {
                texture = this.textures[Textures.TRUNK_MEDIUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TRUNK_LOW.ordinal()];
            }
        }
        textureManager.func_110577_a(texture);
        this.trunk.func_78785_a(factor);
        textureManager.func_110577_a(this.textures[Textures.EXTENSION.ordinal()]);
        float chamberf = 0.125f;
        if (step > 0.0f) {
            int i = 0;
            while ((float)i <= step + 2.0f) {
                this.extension.func_78785_a(factor);
                GlStateManager.func_179109_b((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
                i += 2;
            }
        }
        GlStateManager.func_179121_F();
    }

    static {
        RenderEngine.angleMap[EnumFacing.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[EnumFacing.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[EnumFacing.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[EnumFacing.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[EnumFacing.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[EnumFacing.NORTH.ordinal()] = -1.5707964f;
    }

    private static class EngineModelBase
    extends ModelBase {
        private EngineModelBase() {
        }
    }

    private static enum Textures {
        BASE,
        PISTON,
        EXTENSION,
        TRUNK_HIGHEST,
        TRUNK_HIGHER,
        TRUNK_HIGH,
        TRUNK_MEDIUM,
        TRUNK_LOW;

    }
}

