/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.data.content;

import forestry.api.book.BookContent;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IGuiElementFactory;
import forestry.book.data.CraftingData;
import forestry.book.gui.elements.CraftingElement;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CraftingContent
extends BookContent<CraftingData> {
    @Override
    public Class<CraftingData> getDataClass() {
        return CraftingData.class;
    }

    @Override
    public boolean addElements(IElementGroup page, IGuiElementFactory factory, @Nullable BookContent previous, @Nullable IGuiElement previousElement, int pageHeight) {
        if (this.data == null || ((CraftingData)this.data).locations.length == 0) {
            return false;
        }
        LinkedList<IRecipe> recipes = new LinkedList<IRecipe>();
        for (ResourceLocation location : ((CraftingData)this.data).locations) {
            IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(location);
            if (recipe == null) continue;
            recipes.add(recipe);
        }
        page.add(new CraftingElement(0, 0, recipes.toArray(new IRecipe[0])));
        return true;
    }
}

