/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.dirt2path;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="dirt2path", name="Dirt2Path", version="1.7.1", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12,1.12.2]")
public class Dirt2Path {
    public static final String MOD_ID = "dirt2path";
    public static final String MOD_NAME = "Dirt2Path";
    public static Logger logger = LogManager.getLogger((String)"dirt2path");
    public static Configuration config;
    public static boolean flattenBOP;
    public static boolean flattenBotania;
    public static boolean flattenMycelium;
    public static boolean raisePath;
    public static boolean raisePathSneaky;
    public static boolean raiseFarmland;
    public static boolean patchCOFH;
    @GameRegistry.ObjectHolder(value="biomesoplenty:grass")
    public static final Block BOP_GRASS;
    @GameRegistry.ObjectHolder(value="biomesoplenty:grass_path")
    public static final Block BOP_GRASS_PATH;
    @GameRegistry.ObjectHolder(value="biomesoplenty:dirt")
    public static final Block BOP_DIRT;
    @GameRegistry.ObjectHolder(value="biomesoplenty:farmland_0")
    public static final Block BOP_FARMLAND_0;
    @GameRegistry.ObjectHolder(value="biomesoplenty:farmland_1")
    public static final Block BOP_FARMLAND_1;
    @GameRegistry.ObjectHolder(value="botania:altgrass")
    public static final Block BOTANIA_GRASS_1_11_2;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        flattenMycelium = config.getBoolean("Flatten Mycelium", "General", true, "Enables converting Mycelium into Path Blocks");
        raisePath = config.getBoolean("Take Backsies", "General", true, "Convert Path Blocks to Dirt on Right Click");
        raisePathSneaky = config.getBoolean("Take Bascies Sneaky", "General", true, "If True, You have to be sneaking to use Take Backsies");
        raiseFarmland = config.getBoolean("Remove Farmland", "General", true, "Convert Farmland Blocks to Dirt on Right Click when Sneaking.");
        flattenBOP = config.getBoolean("Biomes O Plenty", "General", true, "Convert Biomes O Plenty Loamy, Sandy, and Silty Dirt into the appropriate Path blocks");
        flattenBotania = config.getBoolean("Botania", "General", true, "Convert Botania Grasses to the default Grass Path.");
        config.save();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockRightclick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        ItemStack itemStack = player.func_184586_b(event.getHand());
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!itemStack.func_77973_b().getToolClasses(itemStack).contains("shovel")) {
            return;
        }
        IBlockState iBlockState = world.func_180495_p(blockPos);
        if (world.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            if (this.isBlockDirt(iBlockState, itemStack)) {
                IBlockState pathState = this.getPathBlockState(iBlockState, itemStack);
                this.setPathOrDirt(world, pathState, blockPos, SoundEvents.field_187771_eN, player, itemStack, event.getHand());
            } else if (raisePath && this.requiresSneaking(player) && this.isBlockPath(iBlockState)) {
                IBlockState dirtState = this.getDirtBlockState(iBlockState);
                this.setPathOrDirt(world, dirtState, blockPos, SoundEvents.field_187693_cj, player, itemStack, event.getHand());
            } else if (raiseFarmland && player.func_70093_af() && this.isBlockFarmland(iBlockState)) {
                IBlockState dirtState = this.getDirtBlockState(iBlockState);
                this.setPathOrDirt(world, dirtState, blockPos, SoundEvents.field_187693_cj, player, itemStack, event.getHand());
            }
        }
    }

    protected boolean requiresSneaking(EntityPlayer player) {
        return !raisePathSneaky || player.func_70093_af();
    }

    protected void setPathOrDirt(World world, IBlockState blockState, BlockPos blockPos, SoundEvent soundEvent, EntityPlayer player, ItemStack itemStack, EnumHand hand) {
        world.func_184133_a(player, blockPos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        player.func_184609_a(hand);
        if (!world.field_72995_K) {
            world.func_180501_a(blockPos, blockState, 11);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    protected boolean isBlockPath(IBlockState iBlockStateIn) {
        int blockMeta = iBlockStateIn.func_177230_c().func_176201_c(iBlockStateIn);
        if (iBlockStateIn.func_177230_c() == Blocks.field_185774_da) {
            return true;
        }
        return flattenBOP && iBlockStateIn.func_177230_c() == BOP_GRASS_PATH;
    }

    protected boolean isBlockDirt(IBlockState iBlockStateIn, ItemStack itemStackIn) {
        int blockMeta = iBlockStateIn.func_177230_c().func_176201_c(iBlockStateIn);
        if (iBlockStateIn.func_177230_c() == Blocks.field_150346_d) {
            return true;
        }
        if (iBlockStateIn.func_177230_c() == Blocks.field_150391_bh) {
            return true;
        }
        if (flattenBOP && iBlockStateIn.func_177230_c() == BOP_DIRT && blockMeta < 4) {
            return true;
        }
        if (flattenBOP && iBlockStateIn.func_177230_c() == BOP_GRASS && blockMeta > 4) {
            return true;
        }
        return flattenBotania && iBlockStateIn.func_177230_c() == BOTANIA_GRASS_1_11_2;
    }

    protected boolean isBlockFarmland(IBlockState iBlockStateIn) {
        int blockMeta = iBlockStateIn.func_177230_c().func_176201_c(iBlockStateIn);
        if (iBlockStateIn.func_177230_c() == Blocks.field_150458_ak) {
            return true;
        }
        if (iBlockStateIn.func_177230_c() == BOP_FARMLAND_0) {
            return true;
        }
        return iBlockStateIn.func_177230_c() == BOP_FARMLAND_1;
    }

    protected IBlockState getDirtBlockState(IBlockState iBlockState) {
        int blockMeta = iBlockState.func_177230_c().func_176201_c(iBlockState);
        if (iBlockState.func_177230_c() == BOP_GRASS_PATH && blockMeta < 4) {
            return BOP_DIRT.func_176203_a(blockMeta);
        }
        if (iBlockState.func_177230_c() == BOP_FARMLAND_0) {
            return BOP_DIRT.func_176203_a(blockMeta & 1);
        }
        if (iBlockState.func_177230_c() == BOP_FARMLAND_1) {
            return BOP_DIRT.func_176203_a(3);
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    protected IBlockState getPathBlockState(IBlockState iBlockStateIn, ItemStack itemStackIn) {
        int blockMeta = iBlockStateIn.func_177230_c().func_176201_c(iBlockStateIn);
        if (iBlockStateIn.func_177230_c() == BOP_DIRT && blockMeta < 4) {
            return BOP_GRASS_PATH.func_176203_a(blockMeta);
        }
        return Blocks.field_185774_da.func_176223_P();
    }

    static {
        BOP_GRASS = null;
        BOP_GRASS_PATH = null;
        BOP_DIRT = null;
        BOP_FARMLAND_0 = null;
        BOP_FARMLAND_1 = null;
        BOTANIA_GRASS_1_11_2 = null;
    }
}

