/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers.accessories;

import c4.conarm.ConstructsArmory;
import c4.conarm.client.models.accessories.ModelKnapsack;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.modifiers.IAccessoryRender;
import c4.conarm.lib.utils.ConstructUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;

public class ModTravelSack
extends AccessoryModifier
implements IAccessoryRender {
    public static final int SACK_SIZE = 27;
    @SideOnly(value=Side.CLIENT)
    private static ModelKnapsack model;
    private static ResourceLocation texture;
    private static final String TAG_KNAPSACK = "knapsack";

    public ModTravelSack() {
        super("travel_sack");
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        NBTTagCompound oldSack = modifierTag.func_74775_l(TAG_KNAPSACK);
        if (oldSack.func_82582_d()) {
            modifierTag.func_74782_a(TAG_KNAPSACK, (NBTBase)new ItemStackHandler(27).serializeNBT());
        } else {
            modifierTag.func_74782_a(TAG_KNAPSACK, (NBTBase)oldSack);
        }
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST && super.canApplyCustom(stack);
    }

    @Override
    public void onKeybinding(ItemStack armor, EntityPlayer player) {
        this.openKnapsack(player);
    }

    private void openKnapsack(EntityPlayer player) {
        player.openGui((Object)ConstructsArmory.instance, 0, player.field_70170_p, 0, 0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onAccessoryRender(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (model == null) {
            model = new ModelKnapsack();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    static {
        texture = ConstructUtils.getResource("textures/models/accessories/travel_sack.png");
    }

    public static class KnapsackData
    extends ModifierNBT {
        public ItemStackHandler knapsack = new ItemStackHandler(27);

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.knapsack.deserializeNBT((NBTTagCompound)tag.func_74781_a(ModTravelSack.TAG_KNAPSACK));
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74782_a(ModTravelSack.TAG_KNAPSACK, (NBTBase)this.knapsack.serializeNBT());
        }
    }
}

