/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.util;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ComparableItemMap<T> {
    private final Map<ComparableItemStack, T> backingMap;
    private final boolean compareOreDict;
    private final boolean compareNbt;

    public ComparableItemMap(boolean compareOreDict, boolean compareNbt) {
        this(new HashMap(), compareOreDict, compareNbt);
    }

    public ComparableItemMap(Map<ComparableItemStack, T> backingMap, boolean compareOreDict, boolean compareNbt) {
        this.backingMap = backingMap;
        this.compareOreDict = compareOreDict;
        this.compareNbt = compareNbt;
    }

    public void put(ItemStack stack, T value) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Stack cannot be empty!");
        }
        this.backingMap.put(this.getKey(stack), value);
    }

    @Nullable
    public T get(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return this.backingMap.get(this.getKey(stack));
    }

    public Optional<T> lookup(ItemStack stack) {
        return Optional.ofNullable(this.get(stack));
    }

    public boolean containsKey(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.backingMap.containsKey(this.getKey(stack));
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    private ComparableItemStack getKey(ItemStack stack) {
        ComparableItemStack key = new ComparableItemStack(stack, this.compareOreDict);
        key.setUseNBT(this.compareNbt);
        return key;
    }
}

